package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  ActionLink,
  Message,
  Timestamp,
  DomainId,
  Title,
  TaskId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class NotificationOutput(
    actionLink: ActionLink,
    creationTimestamp: Timestamp,
    domainIdentifier: DomainId,
    identifier: TaskId,
    lastUpdatedTimestamp: Timestamp,
    message: Message,
    metadata: Optional[Map[String, String]] = Optional.Absent,
    status: Optional[zio.aws.datazone.model.TaskStatus] = Optional.Absent,
    title: Title,
    topic: zio.aws.datazone.model.Topic,
    `type`: zio.aws.datazone.model.NotificationType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.NotificationOutput = {
    import NotificationOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.NotificationOutput
      .builder()
      .actionLink(ActionLink.unwrap(actionLink): java.lang.String)
      .creationTimestamp(Timestamp.unwrap(creationTimestamp): Instant)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .identifier(TaskId.unwrap(identifier): java.lang.String)
      .lastUpdatedTimestamp(Timestamp.unwrap(lastUpdatedTimestamp): Instant)
      .message(Message.unwrap(message): java.lang.String)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .title(Title.unwrap(title): java.lang.String)
      .topic(topic.buildAwsValue())
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.NotificationOutput.ReadOnly =
    zio.aws.datazone.model.NotificationOutput.wrap(buildAwsValue())
}
object NotificationOutput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.NotificationOutput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.NotificationOutput =
      zio.aws.datazone.model.NotificationOutput(
        actionLink,
        creationTimestamp,
        domainIdentifier,
        identifier,
        lastUpdatedTimestamp,
        message,
        metadata.map(value => value),
        status.map(value => value),
        title,
        topic.asEditable,
        `type`
      )
    def actionLink: ActionLink
    def creationTimestamp: Timestamp
    def domainIdentifier: DomainId
    def identifier: TaskId
    def lastUpdatedTimestamp: Timestamp
    def message: Message
    def metadata: Optional[Map[String, String]]
    def status: Optional[zio.aws.datazone.model.TaskStatus]
    def title: Title
    def topic: zio.aws.datazone.model.Topic.ReadOnly
    def `type`: zio.aws.datazone.model.NotificationType
    def getActionLink: ZIO[Any, Nothing, ActionLink] = ZIO.succeed(actionLink)
    def getCreationTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationTimestamp)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getIdentifier: ZIO[Any, Nothing, TaskId] = ZIO.succeed(identifier)
    def getLastUpdatedTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedTimestamp)
    def getMessage: ZIO[Any, Nothing, Message] = ZIO.succeed(message)
    def getMetadata: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getStatus: ZIO[Any, AwsError, zio.aws.datazone.model.TaskStatus] =
      AwsError.unwrapOptionField("status", status)
    def getTitle: ZIO[Any, Nothing, Title] = ZIO.succeed(title)
    def getTopic: ZIO[Any, Nothing, zio.aws.datazone.model.Topic.ReadOnly] =
      ZIO.succeed(topic)
    def getType: ZIO[Any, Nothing, zio.aws.datazone.model.NotificationType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.NotificationOutput
  ) extends zio.aws.datazone.model.NotificationOutput.ReadOnly {
    override val actionLink: ActionLink =
      zio.aws.datazone.model.primitives.ActionLink(impl.actionLink())
    override val creationTimestamp: Timestamp =
      zio.aws.datazone.model.primitives.Timestamp(impl.creationTimestamp())
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val identifier: TaskId =
      zio.aws.datazone.model.primitives.TaskId(impl.identifier())
    override val lastUpdatedTimestamp: Timestamp =
      zio.aws.datazone.model.primitives.Timestamp(impl.lastUpdatedTimestamp())
    override val message: Message =
      zio.aws.datazone.model.primitives.Message(impl.message())
    override val metadata: Optional[Map[String, String]] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
    override val status: Optional[zio.aws.datazone.model.TaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.TaskStatus.wrap(value))
    override val title: Title =
      zio.aws.datazone.model.primitives.Title(impl.title())
    override val topic: zio.aws.datazone.model.Topic.ReadOnly =
      zio.aws.datazone.model.Topic.wrap(impl.topic())
    override val `type`: zio.aws.datazone.model.NotificationType =
      zio.aws.datazone.model.NotificationType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.NotificationOutput
  ): zio.aws.datazone.model.NotificationOutput.ReadOnly = new Wrapper(impl)
}
