package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  ProjectId,
  DomainId,
  PaginationToken,
  MaxResults,
  SubscriptionRequestId,
  ListingId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListSubscriptionsRequest(
    approverProjectId: Optional[ProjectId] = Optional.Absent,
    domainIdentifier: DomainId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    owningProjectId: Optional[ProjectId] = Optional.Absent,
    sortBy: Optional[zio.aws.datazone.model.SortKey] = Optional.Absent,
    sortOrder: Optional[zio.aws.datazone.model.SortOrder] = Optional.Absent,
    status: Optional[zio.aws.datazone.model.SubscriptionStatus] =
      Optional.Absent,
    subscribedListingId: Optional[ListingId] = Optional.Absent,
    subscriptionRequestIdentifier: Optional[SubscriptionRequestId] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest = {
    import ListSubscriptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest
      .builder()
      .optionallyWith(
        approverProjectId.map(value =>
          ProjectId.unwrap(value): java.lang.String
        )
      )(_.approverProjectId)
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        owningProjectId.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.owningProjectId)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        subscribedListingId.map(value =>
          ListingId.unwrap(value): java.lang.String
        )
      )(_.subscribedListingId)
      .optionallyWith(
        subscriptionRequestIdentifier.map(value =>
          SubscriptionRequestId.unwrap(value): java.lang.String
        )
      )(_.subscriptionRequestIdentifier)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.ListSubscriptionsRequest.ReadOnly =
    zio.aws.datazone.model.ListSubscriptionsRequest.wrap(buildAwsValue())
}
object ListSubscriptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.ListSubscriptionsRequest =
      zio.aws.datazone.model.ListSubscriptionsRequest(
        approverProjectId.map(value => value),
        domainIdentifier,
        maxResults.map(value => value),
        nextToken.map(value => value),
        owningProjectId.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value),
        status.map(value => value),
        subscribedListingId.map(value => value),
        subscriptionRequestIdentifier.map(value => value)
      )
    def approverProjectId: Optional[ProjectId]
    def domainIdentifier: DomainId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def owningProjectId: Optional[ProjectId]
    def sortBy: Optional[zio.aws.datazone.model.SortKey]
    def sortOrder: Optional[zio.aws.datazone.model.SortOrder]
    def status: Optional[zio.aws.datazone.model.SubscriptionStatus]
    def subscribedListingId: Optional[ListingId]
    def subscriptionRequestIdentifier: Optional[SubscriptionRequestId]
    def getApproverProjectId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("approverProjectId", approverProjectId)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOwningProjectId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("owningProjectId", owningProjectId)
    def getSortBy: ZIO[Any, AwsError, zio.aws.datazone.model.SortKey] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.datazone.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datazone.model.SubscriptionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSubscribedListingId: ZIO[Any, AwsError, ListingId] =
      AwsError.unwrapOptionField("subscribedListingId", subscribedListingId)
    def getSubscriptionRequestIdentifier
        : ZIO[Any, AwsError, SubscriptionRequestId] =
      AwsError.unwrapOptionField(
        "subscriptionRequestIdentifier",
        subscriptionRequestIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest
  ) extends zio.aws.datazone.model.ListSubscriptionsRequest.ReadOnly {
    override val approverProjectId: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.approverProjectId())
      .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datazone.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datazone.model.primitives.PaginationToken(value))
    override val owningProjectId: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.owningProjectId())
      .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
    override val sortBy: Optional[zio.aws.datazone.model.SortKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value => zio.aws.datazone.model.SortKey.wrap(value))
    override val sortOrder: Optional[zio.aws.datazone.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.datazone.model.SortOrder.wrap(value))
    override val status: Optional[zio.aws.datazone.model.SubscriptionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.SubscriptionStatus.wrap(value))
    override val subscribedListingId: Optional[ListingId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscribedListingId())
        .map(value => zio.aws.datazone.model.primitives.ListingId(value))
    override val subscriptionRequestIdentifier
        : Optional[SubscriptionRequestId] = zio.aws.core.internal
      .optionalFromNullable(impl.subscriptionRequestIdentifier())
      .map(value =>
        zio.aws.datazone.model.primitives.SubscriptionRequestId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.ListSubscriptionsRequest
  ): zio.aws.datazone.model.ListSubscriptionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
