package zio.aws.datazone.model
import zio.aws.datazone.model.primitives.{
  ProjectId,
  CreatedAt,
  DomainId,
  Revision,
  Description,
  CreatedBy,
  FormTypeName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class FormTypeData(
    createdAt: Optional[CreatedAt] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    domainId: DomainId,
    imports: Optional[Iterable[zio.aws.datazone.model.Import]] =
      Optional.Absent,
    model: Optional[zio.aws.datazone.model.Model] = Optional.Absent,
    name: FormTypeName,
    originDomainId: Optional[DomainId] = Optional.Absent,
    originProjectId: Optional[ProjectId] = Optional.Absent,
    owningProjectId: Optional[ProjectId] = Optional.Absent,
    revision: Revision,
    status: Optional[zio.aws.datazone.model.FormTypeStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.FormTypeData = {
    import FormTypeData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.FormTypeData
      .builder()
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .domainId(DomainId.unwrap(domainId): java.lang.String)
      .optionallyWith(
        imports.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.imports)
      .optionallyWith(model.map(value => value.buildAwsValue()))(_.model)
      .name(FormTypeName.unwrap(name): java.lang.String)
      .optionallyWith(
        originDomainId.map(value => DomainId.unwrap(value): java.lang.String)
      )(_.originDomainId)
      .optionallyWith(
        originProjectId.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.originProjectId)
      .optionallyWith(
        owningProjectId.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.owningProjectId)
      .revision(Revision.unwrap(revision): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.FormTypeData.ReadOnly =
    zio.aws.datazone.model.FormTypeData.wrap(buildAwsValue())
}
object FormTypeData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.FormTypeData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.FormTypeData =
      zio.aws.datazone.model.FormTypeData(
        createdAt.map(value => value),
        createdBy.map(value => value),
        description.map(value => value),
        domainId,
        imports.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        model.map(value => value.asEditable),
        name,
        originDomainId.map(value => value),
        originProjectId.map(value => value),
        owningProjectId.map(value => value),
        revision,
        status.map(value => value)
      )
    def createdAt: Optional[CreatedAt]
    def createdBy: Optional[CreatedBy]
    def description: Optional[Description]
    def domainId: DomainId
    def imports: Optional[List[zio.aws.datazone.model.Import.ReadOnly]]
    def model: Optional[zio.aws.datazone.model.Model.ReadOnly]
    def name: FormTypeName
    def originDomainId: Optional[DomainId]
    def originProjectId: Optional[ProjectId]
    def owningProjectId: Optional[ProjectId]
    def revision: Revision
    def status: Optional[zio.aws.datazone.model.FormTypeStatus]
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDomainId: ZIO[Any, Nothing, DomainId] = ZIO.succeed(domainId)
    def getImports
        : ZIO[Any, AwsError, List[zio.aws.datazone.model.Import.ReadOnly]] =
      AwsError.unwrapOptionField("imports", imports)
    def getModel: ZIO[Any, AwsError, zio.aws.datazone.model.Model.ReadOnly] =
      AwsError.unwrapOptionField("model", model)
    def getName: ZIO[Any, Nothing, FormTypeName] = ZIO.succeed(name)
    def getOriginDomainId: ZIO[Any, AwsError, DomainId] =
      AwsError.unwrapOptionField("originDomainId", originDomainId)
    def getOriginProjectId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("originProjectId", originProjectId)
    def getOwningProjectId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("owningProjectId", owningProjectId)
    def getRevision: ZIO[Any, Nothing, Revision] = ZIO.succeed(revision)
    def getStatus: ZIO[Any, AwsError, zio.aws.datazone.model.FormTypeStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.FormTypeData
  ) extends zio.aws.datazone.model.FormTypeData.ReadOnly {
    override val createdAt: Optional[CreatedAt] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.datazone.model.primitives.CreatedAt(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.datazone.model.primitives.CreatedBy(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.datazone.model.primitives.Description(value))
    override val domainId: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainId())
    override val imports
        : Optional[List[zio.aws.datazone.model.Import.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imports())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datazone.model.Import.wrap(item)
          }.toList
        )
    override val model: Optional[zio.aws.datazone.model.Model.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.model())
        .map(value => zio.aws.datazone.model.Model.wrap(value))
    override val name: FormTypeName =
      zio.aws.datazone.model.primitives.FormTypeName(impl.name())
    override val originDomainId: Optional[DomainId] = zio.aws.core.internal
      .optionalFromNullable(impl.originDomainId())
      .map(value => zio.aws.datazone.model.primitives.DomainId(value))
    override val originProjectId: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.originProjectId())
      .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
    override val owningProjectId: Optional[ProjectId] = zio.aws.core.internal
      .optionalFromNullable(impl.owningProjectId())
      .map(value => zio.aws.datazone.model.primitives.ProjectId(value))
    override val revision: Revision =
      zio.aws.datazone.model.primitives.Revision(impl.revision())
    override val status: Optional[zio.aws.datazone.model.FormTypeStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datazone.model.FormTypeStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.FormTypeData
  ): zio.aws.datazone.model.FormTypeData.ReadOnly = new Wrapper(impl)
}
