package zio.aws.datazone.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.datazone.model.primitives.{GroupIdentifier, DomainId}
import scala.jdk.CollectionConverters._
final case class CreateGroupProfileRequest(
    clientToken: Optional[String] = Optional.Absent,
    domainIdentifier: DomainId,
    groupIdentifier: GroupIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datazone.model.CreateGroupProfileRequest = {
    import CreateGroupProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datazone.model.CreateGroupProfileRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .domainIdentifier(DomainId.unwrap(domainIdentifier): java.lang.String)
      .groupIdentifier(
        GroupIdentifier.unwrap(groupIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datazone.model.CreateGroupProfileRequest.ReadOnly =
    zio.aws.datazone.model.CreateGroupProfileRequest.wrap(buildAwsValue())
}
object CreateGroupProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datazone.model.CreateGroupProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datazone.model.CreateGroupProfileRequest =
      zio.aws.datazone.model.CreateGroupProfileRequest(
        clientToken.map(value => value),
        domainIdentifier,
        groupIdentifier
      )
    def clientToken: Optional[String]
    def domainIdentifier: DomainId
    def groupIdentifier: GroupIdentifier
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDomainIdentifier: ZIO[Any, Nothing, DomainId] =
      ZIO.succeed(domainIdentifier)
    def getGroupIdentifier: ZIO[Any, Nothing, GroupIdentifier] =
      ZIO.succeed(groupIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datazone.model.CreateGroupProfileRequest
  ) extends zio.aws.datazone.model.CreateGroupProfileRequest.ReadOnly {
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
    override val domainIdentifier: DomainId =
      zio.aws.datazone.model.primitives.DomainId(impl.domainIdentifier())
    override val groupIdentifier: GroupIdentifier =
      zio.aws.datazone.model.primitives.GroupIdentifier(impl.groupIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datazone.model.CreateGroupProfileRequest
  ): zio.aws.datazone.model.CreateGroupProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
