package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  Time,
  LocationArn,
  KerberosPrincipal,
  HdfsReplicationFactor,
  HdfsUser,
  LocationUri,
  KmsKeyProviderUri,
  AgentArn,
  HdfsBlockSize
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeLocationHdfsResponse(
    locationArn: Optional[LocationArn] = Optional.Absent,
    locationUri: Optional[LocationUri] = Optional.Absent,
    nameNodes: Optional[Iterable[zio.aws.datasync.model.HdfsNameNode]] =
      Optional.Absent,
    blockSize: Optional[HdfsBlockSize] = Optional.Absent,
    replicationFactor: Optional[HdfsReplicationFactor] = Optional.Absent,
    kmsKeyProviderUri: Optional[KmsKeyProviderUri] = Optional.Absent,
    qopConfiguration: Optional[zio.aws.datasync.model.QopConfiguration] =
      Optional.Absent,
    authenticationType: Optional[
      zio.aws.datasync.model.HdfsAuthenticationType
    ] = Optional.Absent,
    simpleUser: Optional[HdfsUser] = Optional.Absent,
    kerberosPrincipal: Optional[KerberosPrincipal] = Optional.Absent,
    agentArns: Optional[Iterable[AgentArn]] = Optional.Absent,
    creationTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsResponse = {
    import DescribeLocationHdfsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        nameNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nameNodes)
      .optionallyWith(
        blockSize.map(value => HdfsBlockSize.unwrap(value): Integer)
      )(_.blockSize)
      .optionallyWith(
        replicationFactor.map(value =>
          HdfsReplicationFactor.unwrap(value): Integer
        )
      )(_.replicationFactor)
      .optionallyWith(
        kmsKeyProviderUri.map(value =>
          KmsKeyProviderUri.unwrap(value): java.lang.String
        )
      )(_.kmsKeyProviderUri)
      .optionallyWith(qopConfiguration.map(value => value.buildAwsValue()))(
        _.qopConfiguration
      )
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(
        simpleUser.map(value => HdfsUser.unwrap(value): java.lang.String)
      )(_.simpleUser)
      .optionallyWith(
        kerberosPrincipal.map(value =>
          KerberosPrincipal.unwrap(value): java.lang.String
        )
      )(_.kerberosPrincipal)
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeLocationHdfsResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationHdfsResponse.wrap(buildAwsValue())
}
object DescribeLocationHdfsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationHdfsResponse =
      zio.aws.datasync.model.DescribeLocationHdfsResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        nameNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        blockSize.map(value => value),
        replicationFactor.map(value => value),
        kmsKeyProviderUri.map(value => value),
        qopConfiguration.map(value => value.asEditable),
        authenticationType.map(value => value),
        simpleUser.map(value => value),
        kerberosPrincipal.map(value => value),
        agentArns.map(value => value),
        creationTime.map(value => value)
      )
    def locationArn: Optional[LocationArn]
    def locationUri: Optional[LocationUri]
    def nameNodes: Optional[List[zio.aws.datasync.model.HdfsNameNode.ReadOnly]]
    def blockSize: Optional[HdfsBlockSize]
    def replicationFactor: Optional[HdfsReplicationFactor]
    def kmsKeyProviderUri: Optional[KmsKeyProviderUri]
    def qopConfiguration
        : Optional[zio.aws.datasync.model.QopConfiguration.ReadOnly]
    def authenticationType
        : Optional[zio.aws.datasync.model.HdfsAuthenticationType]
    def simpleUser: Optional[HdfsUser]
    def kerberosPrincipal: Optional[KerberosPrincipal]
    def agentArns: Optional[List[AgentArn]]
    def creationTime: Optional[Time]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getNameNodes: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.HdfsNameNode.ReadOnly
    ]] = AwsError.unwrapOptionField("nameNodes", nameNodes)
    def getBlockSize: ZIO[Any, AwsError, HdfsBlockSize] =
      AwsError.unwrapOptionField("blockSize", blockSize)
    def getReplicationFactor: ZIO[Any, AwsError, HdfsReplicationFactor] =
      AwsError.unwrapOptionField("replicationFactor", replicationFactor)
    def getKmsKeyProviderUri: ZIO[Any, AwsError, KmsKeyProviderUri] =
      AwsError.unwrapOptionField("kmsKeyProviderUri", kmsKeyProviderUri)
    def getQopConfiguration
        : ZIO[Any, AwsError, zio.aws.datasync.model.QopConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("qopConfiguration", qopConfiguration)
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.datasync.model.HdfsAuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getSimpleUser: ZIO[Any, AwsError, HdfsUser] =
      AwsError.unwrapOptionField("simpleUser", simpleUser)
    def getKerberosPrincipal: ZIO[Any, AwsError, KerberosPrincipal] =
      AwsError.unwrapOptionField("kerberosPrincipal", kerberosPrincipal)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsResponse
  ) extends zio.aws.datasync.model.DescribeLocationHdfsResponse.ReadOnly {
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Optional[LocationUri] = zio.aws.core.internal
      .optionalFromNullable(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val nameNodes
        : Optional[List[zio.aws.datasync.model.HdfsNameNode.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nameNodes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.HdfsNameNode.wrap(item)
          }.toList
        )
    override val blockSize: Optional[HdfsBlockSize] = zio.aws.core.internal
      .optionalFromNullable(impl.blockSize())
      .map(value => zio.aws.datasync.model.primitives.HdfsBlockSize(value))
    override val replicationFactor: Optional[HdfsReplicationFactor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationFactor())
        .map(value =>
          zio.aws.datasync.model.primitives.HdfsReplicationFactor(value)
        )
    override val kmsKeyProviderUri: Optional[KmsKeyProviderUri] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsKeyProviderUri())
        .map(value =>
          zio.aws.datasync.model.primitives.KmsKeyProviderUri(value)
        )
    override val qopConfiguration
        : Optional[zio.aws.datasync.model.QopConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.qopConfiguration())
        .map(value => zio.aws.datasync.model.QopConfiguration.wrap(value))
    override val authenticationType
        : Optional[zio.aws.datasync.model.HdfsAuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value => zio.aws.datasync.model.HdfsAuthenticationType.wrap(value))
    override val simpleUser: Optional[HdfsUser] = zio.aws.core.internal
      .optionalFromNullable(impl.simpleUser())
      .map(value => zio.aws.datasync.model.primitives.HdfsUser(value))
    override val kerberosPrincipal: Optional[KerberosPrincipal] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosPrincipal())
        .map(value =>
          zio.aws.datasync.model.primitives.KerberosPrincipal(value)
        )
    override val agentArns: Optional[List[AgentArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
    override val creationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsResponse
  ): zio.aws.datasync.model.DescribeLocationHdfsResponse.ReadOnly = new Wrapper(
    impl
  )
}
