package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReportOverrides(
    transferred: Optional[zio.aws.datasync.model.ReportOverride] =
      Optional.Absent,
    verified: Optional[zio.aws.datasync.model.ReportOverride] = Optional.Absent,
    deleted: Optional[zio.aws.datasync.model.ReportOverride] = Optional.Absent,
    skipped: Optional[zio.aws.datasync.model.ReportOverride] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ReportOverrides = {
    import ReportOverrides.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ReportOverrides
      .builder()
      .optionallyWith(transferred.map(value => value.buildAwsValue()))(
        _.transferred
      )
      .optionallyWith(verified.map(value => value.buildAwsValue()))(_.verified)
      .optionallyWith(deleted.map(value => value.buildAwsValue()))(_.deleted)
      .optionallyWith(skipped.map(value => value.buildAwsValue()))(_.skipped)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ReportOverrides.ReadOnly =
    zio.aws.datasync.model.ReportOverrides.wrap(buildAwsValue())
}
object ReportOverrides {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ReportOverrides
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ReportOverrides =
      zio.aws.datasync.model.ReportOverrides(
        transferred.map(value => value.asEditable),
        verified.map(value => value.asEditable),
        deleted.map(value => value.asEditable),
        skipped.map(value => value.asEditable)
      )
    def transferred: Optional[zio.aws.datasync.model.ReportOverride.ReadOnly]
    def verified: Optional[zio.aws.datasync.model.ReportOverride.ReadOnly]
    def deleted: Optional[zio.aws.datasync.model.ReportOverride.ReadOnly]
    def skipped: Optional[zio.aws.datasync.model.ReportOverride.ReadOnly]
    def getTransferred
        : ZIO[Any, AwsError, zio.aws.datasync.model.ReportOverride.ReadOnly] =
      AwsError.unwrapOptionField("transferred", transferred)
    def getVerified
        : ZIO[Any, AwsError, zio.aws.datasync.model.ReportOverride.ReadOnly] =
      AwsError.unwrapOptionField("verified", verified)
    def getDeleted
        : ZIO[Any, AwsError, zio.aws.datasync.model.ReportOverride.ReadOnly] =
      AwsError.unwrapOptionField("deleted", deleted)
    def getSkipped
        : ZIO[Any, AwsError, zio.aws.datasync.model.ReportOverride.ReadOnly] =
      AwsError.unwrapOptionField("skipped", skipped)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ReportOverrides
  ) extends zio.aws.datasync.model.ReportOverrides.ReadOnly {
    override val transferred
        : Optional[zio.aws.datasync.model.ReportOverride.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transferred())
        .map(value => zio.aws.datasync.model.ReportOverride.wrap(value))
    override val verified
        : Optional[zio.aws.datasync.model.ReportOverride.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verified())
        .map(value => zio.aws.datasync.model.ReportOverride.wrap(value))
    override val deleted
        : Optional[zio.aws.datasync.model.ReportOverride.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deleted())
        .map(value => zio.aws.datasync.model.ReportOverride.wrap(value))
    override val skipped
        : Optional[zio.aws.datasync.model.ReportOverride.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skipped())
        .map(value => zio.aws.datasync.model.ReportOverride.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ReportOverrides
  ): zio.aws.datasync.model.ReportOverrides.ReadOnly = new Wrapper(impl)
}
