package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait ReportLevel {
  def unwrap: software.amazon.awssdk.services.datasync.model.ReportLevel
}
object ReportLevel {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.ReportLevel
  ): zio.aws.datasync.model.ReportLevel = value match {
    case software.amazon.awssdk.services.datasync.model.ReportLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.ReportLevel.ERRORS_ONLY =>
      val r = ERRORS_ONLY
      r
    case software.amazon.awssdk.services.datasync.model.ReportLevel.SUCCESSES_AND_ERRORS =>
      val r = SUCCESSES_AND_ERRORS
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.ReportLevel {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ReportLevel =
      software.amazon.awssdk.services.datasync.model.ReportLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object ERRORS_ONLY extends zio.aws.datasync.model.ReportLevel {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ReportLevel =
      software.amazon.awssdk.services.datasync.model.ReportLevel.ERRORS_ONLY
  }
  case object SUCCESSES_AND_ERRORS extends zio.aws.datasync.model.ReportLevel {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ReportLevel =
      software.amazon.awssdk.services.datasync.model.ReportLevel.SUCCESSES_AND_ERRORS
  }
}
