package zio.aws.datasync
import zio.aws.datasync.model.UpdateTaskResponse.ReadOnly
import zio.aws.datasync.model.{
  CancelTaskExecutionRequest,
  DescribeLocationAzureBlobRequest,
  DescribeLocationFsxLustreRequest,
  StartDiscoveryJobRequest,
  UpdateLocationNfsRequest,
  DescribeStorageSystemRequest,
  CreateTaskRequest,
  CreateLocationSmbRequest,
  UpdateAgentRequest,
  CreateLocationFsxLustreRequest,
  ListStorageSystemsRequest,
  DeleteAgentRequest,
  DescribeLocationS3Request,
  DescribeLocationNfsRequest,
  UpdateLocationObjectStorageRequest,
  CreateLocationEfsRequest,
  UpdateLocationSmbRequest,
  ListTagsForResourceRequest,
  DescribeStorageSystemResourceMetricsRequest,
  DescribeTaskRequest,
  CreateLocationNfsRequest,
  DescribeLocationFsxWindowsRequest,
  ListLocationsRequest,
  CreateLocationFsxOntapRequest,
  StartTaskExecutionRequest,
  StopDiscoveryJobRequest,
  CreateLocationFsxOpenZfsRequest,
  GenerateRecommendationsRequest,
  DescribeLocationEfsRequest,
  DescribeLocationFsxOpenZfsRequest,
  DescribeStorageSystemResourcesRequest,
  CreateLocationS3Request,
  ListTasksRequest,
  DeleteTaskRequest,
  CreateLocationObjectStorageRequest,
  UpdateStorageSystemRequest,
  ListTaskExecutionsRequest,
  UpdateLocationAzureBlobRequest,
  UpdateLocationHdfsRequest,
  AddStorageSystemRequest,
  UntagResourceRequest,
  DescribeLocationHdfsRequest,
  DescribeAgentRequest,
  DescribeDiscoveryJobRequest,
  RemoveStorageSystemRequest,
  UpdateDiscoveryJobRequest,
  CreateLocationHdfsRequest,
  CreateAgentRequest,
  CreateLocationFsxWindowsRequest,
  ListDiscoveryJobsRequest,
  CreateLocationAzureBlobRequest,
  DescribeLocationSmbRequest,
  DeleteLocationRequest,
  DescribeTaskExecutionRequest,
  DescribeLocationObjectStorageRequest,
  UpdateTaskExecutionRequest,
  ListAgentsRequest,
  UpdateTaskRequest,
  DescribeLocationFsxOntapRequest,
  TagResourceRequest
}
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.datasync.DataSyncAsyncClient
object DataSyncMock extends Mock[DataSync] {
  object UpdateTaskExecution
      extends Effect[
        UpdateTaskExecutionRequest,
        AwsError,
        zio.aws.datasync.model.UpdateTaskExecutionResponse.ReadOnly
      ]
  object CreateLocationSmb
      extends Effect[
        CreateLocationSmbRequest,
        AwsError,
        zio.aws.datasync.model.CreateLocationSmbResponse.ReadOnly
      ]
  object DescribeStorageSystem
      extends Effect[
        DescribeStorageSystemRequest,
        AwsError,
        zio.aws.datasync.model.DescribeStorageSystemResponse.ReadOnly
      ]
  object ListStorageSystems
      extends Stream[
        ListStorageSystemsRequest,
        AwsError,
        zio.aws.datasync.model.StorageSystemListEntry.ReadOnly
      ]
  object ListStorageSystemsPaginated
      extends Effect[
        ListStorageSystemsRequest,
        AwsError,
        zio.aws.datasync.model.ListStorageSystemsResponse.ReadOnly
      ]
  object DescribeLocationSmb
      extends Effect[
        DescribeLocationSmbRequest,
        AwsError,
        zio.aws.datasync.model.DescribeLocationSmbResponse.ReadOnly
      ]
  object UpdateStorageSystem
      extends Effect[
        UpdateStorageSystemRequest,
        AwsError,
        zio.aws.datasync.model.UpdateStorageSystemResponse.ReadOnly
      ]
  object UpdateLocationHdfs
      extends Effect[
        UpdateLocationHdfsRequest,
        AwsError,
        zio.aws.datasync.model.UpdateLocationHdfsResponse.ReadOnly
      ]
  object CreateTask
      extends Effect[
        CreateTaskRequest,
        AwsError,
        zio.aws.datasync.model.CreateTaskResponse.ReadOnly
      ]
  object CreateAgent
      extends Effect[
        CreateAgentRequest,
        AwsError,
        zio.aws.datasync.model.CreateAgentResponse.ReadOnly
      ]
  object DescribeLocationFsxLustre
      extends Effect[
        DescribeLocationFsxLustreRequest,
        AwsError,
        zio.aws.datasync.model.DescribeLocationFsxLustreResponse.ReadOnly
      ]
  object StartTaskExecution
      extends Effect[
        StartTaskExecutionRequest,
        AwsError,
        zio.aws.datasync.model.StartTaskExecutionResponse.ReadOnly
      ]
  object CreateLocationObjectStorage
      extends Effect[
        CreateLocationObjectStorageRequest,
        AwsError,
        zio.aws.datasync.model.CreateLocationObjectStorageResponse.ReadOnly
      ]
  object DeleteTask
      extends Effect[
        DeleteTaskRequest,
        AwsError,
        zio.aws.datasync.model.DeleteTaskResponse.ReadOnly
      ]
  object DescribeLocationS3
      extends Effect[
        DescribeLocationS3Request,
        AwsError,
        zio.aws.datasync.model.DescribeLocationS3Response.ReadOnly
      ]
  object CreateLocationFsxLustre
      extends Effect[
        CreateLocationFsxLustreRequest,
        AwsError,
        zio.aws.datasync.model.CreateLocationFsxLustreResponse.ReadOnly
      ]
  object CreateLocationNfs
      extends Effect[
        CreateLocationNfsRequest,
        AwsError,
        zio.aws.datasync.model.CreateLocationNfsResponse.ReadOnly
      ]
  object DescribeStorageSystemResources
      extends Effect[
        DescribeStorageSystemResourcesRequest,
        AwsError,
        zio.aws.datasync.model.DescribeStorageSystemResourcesResponse.ReadOnly
      ]
  object CreateLocationFsxWindows
      extends Effect[
        CreateLocationFsxWindowsRequest,
        AwsError,
        zio.aws.datasync.model.CreateLocationFsxWindowsResponse.ReadOnly
      ]
  object UpdateLocationSmb
      extends Effect[
        UpdateLocationSmbRequest,
        AwsError,
        zio.aws.datasync.model.UpdateLocationSmbResponse.ReadOnly
      ]
  object CancelTaskExecution
      extends Effect[
        CancelTaskExecutionRequest,
        AwsError,
        zio.aws.datasync.model.CancelTaskExecutionResponse.ReadOnly
      ]
  object GenerateRecommendations
      extends Effect[
        GenerateRecommendationsRequest,
        AwsError,
        zio.aws.datasync.model.GenerateRecommendationsResponse.ReadOnly
      ]
  object DescribeAgent
      extends Effect[
        DescribeAgentRequest,
        AwsError,
        zio.aws.datasync.model.DescribeAgentResponse.ReadOnly
      ]
  object DescribeStorageSystemResourceMetrics
      extends Stream[
        DescribeStorageSystemResourceMetricsRequest,
        AwsError,
        zio.aws.datasync.model.ResourceMetrics.ReadOnly
      ]
  object DescribeStorageSystemResourceMetricsPaginated
      extends Effect[
        DescribeStorageSystemResourceMetricsRequest,
        AwsError,
        zio.aws.datasync.model.DescribeStorageSystemResourceMetricsResponse.ReadOnly
      ]
  object ListLocations
      extends Stream[
        ListLocationsRequest,
        AwsError,
        zio.aws.datasync.model.LocationListEntry.ReadOnly
      ]
  object ListLocationsPaginated
      extends Effect[
        ListLocationsRequest,
        AwsError,
        zio.aws.datasync.model.ListLocationsResponse.ReadOnly
      ]
  object CreateLocationFsxOpenZfs
      extends Effect[
        CreateLocationFsxOpenZfsRequest,
        AwsError,
        zio.aws.datasync.model.CreateLocationFsxOpenZfsResponse.ReadOnly
      ]
  object DescribeLocationObjectStorage
      extends Effect[
        DescribeLocationObjectStorageRequest,
        AwsError,
        zio.aws.datasync.model.DescribeLocationObjectStorageResponse.ReadOnly
      ]
  object DescribeLocationEfs
      extends Effect[
        DescribeLocationEfsRequest,
        AwsError,
        zio.aws.datasync.model.DescribeLocationEfsResponse.ReadOnly
      ]
  object UpdateLocationNfs
      extends Effect[
        UpdateLocationNfsRequest,
        AwsError,
        zio.aws.datasync.model.UpdateLocationNfsResponse.ReadOnly
      ]
  object ListDiscoveryJobs
      extends Stream[
        ListDiscoveryJobsRequest,
        AwsError,
        zio.aws.datasync.model.DiscoveryJobListEntry.ReadOnly
      ]
  object ListDiscoveryJobsPaginated
      extends Effect[
        ListDiscoveryJobsRequest,
        AwsError,
        zio.aws.datasync.model.ListDiscoveryJobsResponse.ReadOnly
      ]
  object StopDiscoveryJob
      extends Effect[
        StopDiscoveryJobRequest,
        AwsError,
        zio.aws.datasync.model.StopDiscoveryJobResponse.ReadOnly
      ]
  object RemoveStorageSystem
      extends Effect[
        RemoveStorageSystemRequest,
        AwsError,
        zio.aws.datasync.model.RemoveStorageSystemResponse.ReadOnly
      ]
  object DescribeLocationHdfs
      extends Effect[
        DescribeLocationHdfsRequest,
        AwsError,
        zio.aws.datasync.model.DescribeLocationHdfsResponse.ReadOnly
      ]
  object CreateLocationFsxOntap
      extends Effect[
        CreateLocationFsxOntapRequest,
        AwsError,
        zio.aws.datasync.model.CreateLocationFsxOntapResponse.ReadOnly
      ]
  object DeleteLocation
      extends Effect[
        DeleteLocationRequest,
        AwsError,
        zio.aws.datasync.model.DeleteLocationResponse.ReadOnly
      ]
  object DescribeDiscoveryJob
      extends Effect[
        DescribeDiscoveryJobRequest,
        AwsError,
        zio.aws.datasync.model.DescribeDiscoveryJobResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.datasync.model.UntagResourceResponse.ReadOnly
      ]
  object DescribeTaskExecution
      extends Effect[
        DescribeTaskExecutionRequest,
        AwsError,
        zio.aws.datasync.model.DescribeTaskExecutionResponse.ReadOnly
      ]
  object CreateLocationS3
      extends Effect[
        CreateLocationS3Request,
        AwsError,
        zio.aws.datasync.model.CreateLocationS3Response.ReadOnly
      ]
  object UpdateTask extends Effect[UpdateTaskRequest, AwsError, ReadOnly]
  object ListTaskExecutions
      extends Stream[
        ListTaskExecutionsRequest,
        AwsError,
        zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly
      ]
  object ListTaskExecutionsPaginated
      extends Effect[
        ListTaskExecutionsRequest,
        AwsError,
        zio.aws.datasync.model.ListTaskExecutionsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.datasync.model.TagListEntry.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.datasync.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.datasync.model.TagResourceResponse.ReadOnly
      ]
  object DescribeLocationFsxOpenZfs
      extends Effect[
        DescribeLocationFsxOpenZfsRequest,
        AwsError,
        zio.aws.datasync.model.DescribeLocationFsxOpenZfsResponse.ReadOnly
      ]
  object CreateLocationAzureBlob
      extends Effect[
        CreateLocationAzureBlobRequest,
        AwsError,
        zio.aws.datasync.model.CreateLocationAzureBlobResponse.ReadOnly
      ]
  object AddStorageSystem
      extends Effect[
        AddStorageSystemRequest,
        AwsError,
        zio.aws.datasync.model.AddStorageSystemResponse.ReadOnly
      ]
  object UpdateLocationAzureBlob
      extends Effect[
        UpdateLocationAzureBlobRequest,
        AwsError,
        zio.aws.datasync.model.UpdateLocationAzureBlobResponse.ReadOnly
      ]
  object UpdateLocationObjectStorage
      extends Effect[
        UpdateLocationObjectStorageRequest,
        AwsError,
        zio.aws.datasync.model.UpdateLocationObjectStorageResponse.ReadOnly
      ]
  object ListTasks
      extends Stream[
        ListTasksRequest,
        AwsError,
        zio.aws.datasync.model.TaskListEntry.ReadOnly
      ]
  object ListTasksPaginated
      extends Effect[
        ListTasksRequest,
        AwsError,
        zio.aws.datasync.model.ListTasksResponse.ReadOnly
      ]
  object DescribeLocationAzureBlob
      extends Effect[
        DescribeLocationAzureBlobRequest,
        AwsError,
        zio.aws.datasync.model.DescribeLocationAzureBlobResponse.ReadOnly
      ]
  object ListAgents
      extends Stream[
        ListAgentsRequest,
        AwsError,
        zio.aws.datasync.model.AgentListEntry.ReadOnly
      ]
  object ListAgentsPaginated
      extends Effect[
        ListAgentsRequest,
        AwsError,
        zio.aws.datasync.model.ListAgentsResponse.ReadOnly
      ]
  object CreateLocationHdfs
      extends Effect[
        CreateLocationHdfsRequest,
        AwsError,
        zio.aws.datasync.model.CreateLocationHdfsResponse.ReadOnly
      ]
  object DeleteAgent
      extends Effect[
        DeleteAgentRequest,
        AwsError,
        zio.aws.datasync.model.DeleteAgentResponse.ReadOnly
      ]
  object CreateLocationEfs
      extends Effect[
        CreateLocationEfsRequest,
        AwsError,
        zio.aws.datasync.model.CreateLocationEfsResponse.ReadOnly
      ]
  object DescribeLocationFsxWindows
      extends Effect[
        DescribeLocationFsxWindowsRequest,
        AwsError,
        zio.aws.datasync.model.DescribeLocationFsxWindowsResponse.ReadOnly
      ]
  object DescribeTask
      extends Effect[
        DescribeTaskRequest,
        AwsError,
        zio.aws.datasync.model.DescribeTaskResponse.ReadOnly
      ]
  object UpdateAgent
      extends Effect[
        UpdateAgentRequest,
        AwsError,
        zio.aws.datasync.model.UpdateAgentResponse.ReadOnly
      ]
  object UpdateDiscoveryJob
      extends Effect[
        UpdateDiscoveryJobRequest,
        AwsError,
        zio.aws.datasync.model.UpdateDiscoveryJobResponse.ReadOnly
      ]
  object StartDiscoveryJob
      extends Effect[
        StartDiscoveryJobRequest,
        AwsError,
        zio.aws.datasync.model.StartDiscoveryJobResponse.ReadOnly
      ]
  object DescribeLocationFsxOntap
      extends Effect[
        DescribeLocationFsxOntapRequest,
        AwsError,
        zio.aws.datasync.model.DescribeLocationFsxOntapResponse.ReadOnly
      ]
  object DescribeLocationNfs
      extends Effect[
        DescribeLocationNfsRequest,
        AwsError,
        zio.aws.datasync.model.DescribeLocationNfsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, DataSync] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, DataSync] { rts =>
        zio.ZIO.succeed {
          new DataSync {
            val api: DataSyncAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): DataSync = this
            def updateTaskExecution(request: UpdateTaskExecutionRequest): IO[
              AwsError,
              zio.aws.datasync.model.UpdateTaskExecutionResponse.ReadOnly
            ] = proxy(UpdateTaskExecution, request)
            def createLocationSmb(request: CreateLocationSmbRequest): IO[
              AwsError,
              zio.aws.datasync.model.CreateLocationSmbResponse.ReadOnly
            ] = proxy(CreateLocationSmb, request)
            def describeStorageSystem(
                request: DescribeStorageSystemRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.DescribeStorageSystemResponse.ReadOnly
            ] = proxy(DescribeStorageSystem, request)
            def listStorageSystems(request: ListStorageSystemsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datasync.model.StorageSystemListEntry.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStorageSystems, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStorageSystemsPaginated(
                request: ListStorageSystemsRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.ListStorageSystemsResponse.ReadOnly
            ] = proxy(ListStorageSystemsPaginated, request)
            def describeLocationSmb(request: DescribeLocationSmbRequest): IO[
              AwsError,
              zio.aws.datasync.model.DescribeLocationSmbResponse.ReadOnly
            ] = proxy(DescribeLocationSmb, request)
            def updateStorageSystem(request: UpdateStorageSystemRequest): IO[
              AwsError,
              zio.aws.datasync.model.UpdateStorageSystemResponse.ReadOnly
            ] = proxy(UpdateStorageSystem, request)
            def updateLocationHdfs(request: UpdateLocationHdfsRequest): IO[
              AwsError,
              zio.aws.datasync.model.UpdateLocationHdfsResponse.ReadOnly
            ] = proxy(UpdateLocationHdfs, request)
            def createTask(request: CreateTaskRequest): IO[
              AwsError,
              zio.aws.datasync.model.CreateTaskResponse.ReadOnly
            ] = proxy(CreateTask, request)
            def createAgent(request: CreateAgentRequest): IO[
              AwsError,
              zio.aws.datasync.model.CreateAgentResponse.ReadOnly
            ] = proxy(CreateAgent, request)
            def describeLocationFsxLustre(
                request: DescribeLocationFsxLustreRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.DescribeLocationFsxLustreResponse.ReadOnly
            ] = proxy(DescribeLocationFsxLustre, request)
            def startTaskExecution(request: StartTaskExecutionRequest): IO[
              AwsError,
              zio.aws.datasync.model.StartTaskExecutionResponse.ReadOnly
            ] = proxy(StartTaskExecution, request)
            def createLocationObjectStorage(
                request: CreateLocationObjectStorageRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.CreateLocationObjectStorageResponse.ReadOnly
            ] = proxy(CreateLocationObjectStorage, request)
            def deleteTask(request: DeleteTaskRequest): IO[
              AwsError,
              zio.aws.datasync.model.DeleteTaskResponse.ReadOnly
            ] = proxy(DeleteTask, request)
            def describeLocationS3(request: DescribeLocationS3Request): IO[
              AwsError,
              zio.aws.datasync.model.DescribeLocationS3Response.ReadOnly
            ] = proxy(DescribeLocationS3, request)
            def createLocationFsxLustre(
                request: CreateLocationFsxLustreRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.CreateLocationFsxLustreResponse.ReadOnly
            ] = proxy(CreateLocationFsxLustre, request)
            def createLocationNfs(request: CreateLocationNfsRequest): IO[
              AwsError,
              zio.aws.datasync.model.CreateLocationNfsResponse.ReadOnly
            ] = proxy(CreateLocationNfs, request)
            def describeStorageSystemResources(
                request: DescribeStorageSystemResourcesRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.DescribeStorageSystemResourcesResponse.ReadOnly
            ] = proxy(DescribeStorageSystemResources, request)
            def createLocationFsxWindows(
                request: CreateLocationFsxWindowsRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.CreateLocationFsxWindowsResponse.ReadOnly
            ] = proxy(CreateLocationFsxWindows, request)
            def updateLocationSmb(request: UpdateLocationSmbRequest): IO[
              AwsError,
              zio.aws.datasync.model.UpdateLocationSmbResponse.ReadOnly
            ] = proxy(UpdateLocationSmb, request)
            def cancelTaskExecution(request: CancelTaskExecutionRequest): IO[
              AwsError,
              zio.aws.datasync.model.CancelTaskExecutionResponse.ReadOnly
            ] = proxy(CancelTaskExecution, request)
            def generateRecommendations(
                request: GenerateRecommendationsRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.GenerateRecommendationsResponse.ReadOnly
            ] = proxy(GenerateRecommendations, request)
            def describeAgent(request: DescribeAgentRequest): IO[
              AwsError,
              zio.aws.datasync.model.DescribeAgentResponse.ReadOnly
            ] = proxy(DescribeAgent, request)
            def describeStorageSystemResourceMetrics(
                request: DescribeStorageSystemResourceMetricsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.datasync.model.ResourceMetrics.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeStorageSystemResourceMetrics, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeStorageSystemResourceMetricsPaginated(
                request: DescribeStorageSystemResourceMetricsRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.DescribeStorageSystemResourceMetricsResponse.ReadOnly
            ] = proxy(DescribeStorageSystemResourceMetricsPaginated, request)
            def listLocations(request: ListLocationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datasync.model.LocationListEntry.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListLocations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listLocationsPaginated(request: ListLocationsRequest): IO[
              AwsError,
              zio.aws.datasync.model.ListLocationsResponse.ReadOnly
            ] = proxy(ListLocationsPaginated, request)
            def createLocationFsxOpenZfs(
                request: CreateLocationFsxOpenZfsRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.CreateLocationFsxOpenZfsResponse.ReadOnly
            ] = proxy(CreateLocationFsxOpenZfs, request)
            def describeLocationObjectStorage(
                request: DescribeLocationObjectStorageRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.DescribeLocationObjectStorageResponse.ReadOnly
            ] = proxy(DescribeLocationObjectStorage, request)
            def describeLocationEfs(request: DescribeLocationEfsRequest): IO[
              AwsError,
              zio.aws.datasync.model.DescribeLocationEfsResponse.ReadOnly
            ] = proxy(DescribeLocationEfs, request)
            def updateLocationNfs(request: UpdateLocationNfsRequest): IO[
              AwsError,
              zio.aws.datasync.model.UpdateLocationNfsResponse.ReadOnly
            ] = proxy(UpdateLocationNfs, request)
            def listDiscoveryJobs(request: ListDiscoveryJobsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datasync.model.DiscoveryJobListEntry.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDiscoveryJobs, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDiscoveryJobsPaginated(
                request: ListDiscoveryJobsRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.ListDiscoveryJobsResponse.ReadOnly
            ] = proxy(ListDiscoveryJobsPaginated, request)
            def stopDiscoveryJob(request: StopDiscoveryJobRequest): IO[
              AwsError,
              zio.aws.datasync.model.StopDiscoveryJobResponse.ReadOnly
            ] = proxy(StopDiscoveryJob, request)
            def removeStorageSystem(request: RemoveStorageSystemRequest): IO[
              AwsError,
              zio.aws.datasync.model.RemoveStorageSystemResponse.ReadOnly
            ] = proxy(RemoveStorageSystem, request)
            def describeLocationHdfs(request: DescribeLocationHdfsRequest): IO[
              AwsError,
              zio.aws.datasync.model.DescribeLocationHdfsResponse.ReadOnly
            ] = proxy(DescribeLocationHdfs, request)
            def createLocationFsxOntap(
                request: CreateLocationFsxOntapRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.CreateLocationFsxOntapResponse.ReadOnly
            ] = proxy(CreateLocationFsxOntap, request)
            def deleteLocation(request: DeleteLocationRequest): IO[
              AwsError,
              zio.aws.datasync.model.DeleteLocationResponse.ReadOnly
            ] = proxy(DeleteLocation, request)
            def describeDiscoveryJob(request: DescribeDiscoveryJobRequest): IO[
              AwsError,
              zio.aws.datasync.model.DescribeDiscoveryJobResponse.ReadOnly
            ] = proxy(DescribeDiscoveryJob, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.datasync.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def describeTaskExecution(
                request: DescribeTaskExecutionRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.DescribeTaskExecutionResponse.ReadOnly
            ] = proxy(DescribeTaskExecution, request)
            def createLocationS3(request: CreateLocationS3Request): IO[
              AwsError,
              zio.aws.datasync.model.CreateLocationS3Response.ReadOnly
            ] = proxy(CreateLocationS3, request)
            def updateTask(request: UpdateTaskRequest): IO[AwsError, ReadOnly] =
              proxy(UpdateTask, request)
            def listTaskExecutions(request: ListTaskExecutionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTaskExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTaskExecutionsPaginated(
                request: ListTaskExecutionsRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.ListTaskExecutionsResponse.ReadOnly
            ] = proxy(ListTaskExecutionsPaginated, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.datasync.model.TagListEntry.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTagsForResource, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.datasync.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def describeLocationFsxOpenZfs(
                request: DescribeLocationFsxOpenZfsRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.DescribeLocationFsxOpenZfsResponse.ReadOnly
            ] = proxy(DescribeLocationFsxOpenZfs, request)
            def createLocationAzureBlob(
                request: CreateLocationAzureBlobRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.CreateLocationAzureBlobResponse.ReadOnly
            ] = proxy(CreateLocationAzureBlob, request)
            def addStorageSystem(request: AddStorageSystemRequest): IO[
              AwsError,
              zio.aws.datasync.model.AddStorageSystemResponse.ReadOnly
            ] = proxy(AddStorageSystem, request)
            def updateLocationAzureBlob(
                request: UpdateLocationAzureBlobRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.UpdateLocationAzureBlobResponse.ReadOnly
            ] = proxy(UpdateLocationAzureBlob, request)
            def updateLocationObjectStorage(
                request: UpdateLocationObjectStorageRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.UpdateLocationObjectStorageResponse.ReadOnly
            ] = proxy(UpdateLocationObjectStorage, request)
            def listTasks(request: ListTasksRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datasync.model.TaskListEntry.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListTasks, request)
                }
                .getOrThrowFiberFailure()
            }
            def listTasksPaginated(
                request: ListTasksRequest
            ): IO[AwsError, zio.aws.datasync.model.ListTasksResponse.ReadOnly] =
              proxy(ListTasksPaginated, request)
            def describeLocationAzureBlob(
                request: DescribeLocationAzureBlobRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.DescribeLocationAzureBlobResponse.ReadOnly
            ] = proxy(DescribeLocationAzureBlob, request)
            def listAgents(request: ListAgentsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.datasync.model.AgentListEntry.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAgents, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAgentsPaginated(request: ListAgentsRequest): IO[
              AwsError,
              zio.aws.datasync.model.ListAgentsResponse.ReadOnly
            ] = proxy(ListAgentsPaginated, request)
            def createLocationHdfs(request: CreateLocationHdfsRequest): IO[
              AwsError,
              zio.aws.datasync.model.CreateLocationHdfsResponse.ReadOnly
            ] = proxy(CreateLocationHdfs, request)
            def deleteAgent(request: DeleteAgentRequest): IO[
              AwsError,
              zio.aws.datasync.model.DeleteAgentResponse.ReadOnly
            ] = proxy(DeleteAgent, request)
            def createLocationEfs(request: CreateLocationEfsRequest): IO[
              AwsError,
              zio.aws.datasync.model.CreateLocationEfsResponse.ReadOnly
            ] = proxy(CreateLocationEfs, request)
            def describeLocationFsxWindows(
                request: DescribeLocationFsxWindowsRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.DescribeLocationFsxWindowsResponse.ReadOnly
            ] = proxy(DescribeLocationFsxWindows, request)
            def describeTask(request: DescribeTaskRequest): IO[
              AwsError,
              zio.aws.datasync.model.DescribeTaskResponse.ReadOnly
            ] = proxy(DescribeTask, request)
            def updateAgent(request: UpdateAgentRequest): IO[
              AwsError,
              zio.aws.datasync.model.UpdateAgentResponse.ReadOnly
            ] = proxy(UpdateAgent, request)
            def updateDiscoveryJob(request: UpdateDiscoveryJobRequest): IO[
              AwsError,
              zio.aws.datasync.model.UpdateDiscoveryJobResponse.ReadOnly
            ] = proxy(UpdateDiscoveryJob, request)
            def startDiscoveryJob(request: StartDiscoveryJobRequest): IO[
              AwsError,
              zio.aws.datasync.model.StartDiscoveryJobResponse.ReadOnly
            ] = proxy(StartDiscoveryJob, request)
            def describeLocationFsxOntap(
                request: DescribeLocationFsxOntapRequest
            ): IO[
              AwsError,
              zio.aws.datasync.model.DescribeLocationFsxOntapResponse.ReadOnly
            ] = proxy(DescribeLocationFsxOntap, request)
            def describeLocationNfs(request: DescribeLocationNfsRequest): IO[
              AwsError,
              zio.aws.datasync.model.DescribeLocationNfsResponse.ReadOnly
            ] = proxy(DescribeLocationNfs, request)
          }
        }
      }
    }
  }
}
