package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait ObjectTags {
  def unwrap: software.amazon.awssdk.services.datasync.model.ObjectTags
}
object ObjectTags {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.ObjectTags
  ): zio.aws.datasync.model.ObjectTags = value match {
    case software.amazon.awssdk.services.datasync.model.ObjectTags.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.ObjectTags.PRESERVE =>
      val r = PRESERVE
      r
    case software.amazon.awssdk.services.datasync.model.ObjectTags.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.ObjectTags {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ObjectTags =
      software.amazon.awssdk.services.datasync.model.ObjectTags.UNKNOWN_TO_SDK_VERSION
  }
  case object PRESERVE extends zio.aws.datasync.model.ObjectTags {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ObjectTags =
      software.amazon.awssdk.services.datasync.model.ObjectTags.PRESERVE
  }
  case object NONE extends zio.aws.datasync.model.ObjectTags {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ObjectTags =
      software.amazon.awssdk.services.datasync.model.ObjectTags.NONE
  }
}
