package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  Time,
  AgentArn,
  LocationUri,
  LocationArn
}
import scala.jdk.CollectionConverters.*
final case class DescribeLocationS3Response(
    locationArn: Optional[LocationArn] = Optional.Absent,
    locationUri: Optional[LocationUri] = Optional.Absent,
    s3StorageClass: Optional[zio.aws.datasync.model.S3StorageClass] =
      Optional.Absent,
    s3Config: Optional[zio.aws.datasync.model.S3Config] = Optional.Absent,
    agentArns: Optional[Iterable[AgentArn]] = Optional.Absent,
    creationTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationS3Response = {
    import DescribeLocationS3Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationS3Response
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(s3StorageClass.map(value => value.unwrap))(
        _.s3StorageClass
      )
      .optionallyWith(s3Config.map(value => value.buildAwsValue()))(_.s3Config)
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeLocationS3Response.ReadOnly =
    zio.aws.datasync.model.DescribeLocationS3Response.wrap(buildAwsValue())
}
object DescribeLocationS3Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationS3Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationS3Response =
      zio.aws.datasync.model.DescribeLocationS3Response(
        locationArn.map(value => value),
        locationUri.map(value => value),
        s3StorageClass.map(value => value),
        s3Config.map(value => value.asEditable),
        agentArns.map(value => value),
        creationTime.map(value => value)
      )
    def locationArn: Optional[LocationArn]
    def locationUri: Optional[LocationUri]
    def s3StorageClass: Optional[zio.aws.datasync.model.S3StorageClass]
    def s3Config: Optional[zio.aws.datasync.model.S3Config.ReadOnly]
    def agentArns: Optional[List[AgentArn]]
    def creationTime: Optional[Time]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getS3StorageClass
        : ZIO[Any, AwsError, zio.aws.datasync.model.S3StorageClass] =
      AwsError.unwrapOptionField("s3StorageClass", s3StorageClass)
    def getS3Config
        : ZIO[Any, AwsError, zio.aws.datasync.model.S3Config.ReadOnly] =
      AwsError.unwrapOptionField("s3Config", s3Config)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationS3Response
  ) extends zio.aws.datasync.model.DescribeLocationS3Response.ReadOnly {
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Optional[LocationUri] = zio.aws.core.internal
      .optionalFromNullable(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val s3StorageClass
        : Optional[zio.aws.datasync.model.S3StorageClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3StorageClass())
        .map(value => zio.aws.datasync.model.S3StorageClass.wrap(value))
    override val s3Config: Optional[zio.aws.datasync.model.S3Config.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Config())
        .map(value => zio.aws.datasync.model.S3Config.wrap(value))
    override val agentArns: Optional[List[AgentArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
    override val creationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationS3Response
  ): zio.aws.datasync.model.DescribeLocationS3Response.ReadOnly = new Wrapper(
    impl
  )
}
