package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  AgentArn,
  AzureBlobSubdirectory,
  AzureBlobContainerUrl
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLocationAzureBlobRequest(
    containerUrl: AzureBlobContainerUrl,
    authenticationType: zio.aws.datasync.model.AzureBlobAuthenticationType,
    sasConfiguration: Optional[
      zio.aws.datasync.model.AzureBlobSasConfiguration
    ] = Optional.Absent,
    blobType: Optional[zio.aws.datasync.model.AzureBlobType] = Optional.Absent,
    accessTier: Optional[zio.aws.datasync.model.AzureAccessTier] =
      Optional.Absent,
    subdirectory: Optional[AzureBlobSubdirectory] = Optional.Absent,
    agentArns: Iterable[AgentArn],
    tags: Optional[Iterable[zio.aws.datasync.model.TagListEntry]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobRequest = {
    import CreateLocationAzureBlobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobRequest
      .builder()
      .containerUrl(
        AzureBlobContainerUrl.unwrap(containerUrl): java.lang.String
      )
      .authenticationType(authenticationType.unwrap)
      .optionallyWith(sasConfiguration.map(value => value.buildAwsValue()))(
        _.sasConfiguration
      )
      .optionallyWith(blobType.map(value => value.unwrap))(_.blobType)
      .optionallyWith(accessTier.map(value => value.unwrap))(_.accessTier)
      .optionallyWith(
        subdirectory.map(value =>
          AzureBlobSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .agentArns(agentArns.map { item =>
        AgentArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.CreateLocationAzureBlobRequest.ReadOnly =
    zio.aws.datasync.model.CreateLocationAzureBlobRequest.wrap(buildAwsValue())
}
object CreateLocationAzureBlobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationAzureBlobRequest =
      zio.aws.datasync.model.CreateLocationAzureBlobRequest(
        containerUrl,
        authenticationType,
        sasConfiguration.map(value => value.asEditable),
        blobType.map(value => value),
        accessTier.map(value => value),
        subdirectory.map(value => value),
        agentArns,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def containerUrl: AzureBlobContainerUrl
    def authenticationType: zio.aws.datasync.model.AzureBlobAuthenticationType
    def sasConfiguration
        : Optional[zio.aws.datasync.model.AzureBlobSasConfiguration.ReadOnly]
    def blobType: Optional[zio.aws.datasync.model.AzureBlobType]
    def accessTier: Optional[zio.aws.datasync.model.AzureAccessTier]
    def subdirectory: Optional[AzureBlobSubdirectory]
    def agentArns: List[AgentArn]
    def tags: Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def getContainerUrl: ZIO[Any, Nothing, AzureBlobContainerUrl] =
      ZIO.succeed(containerUrl)
    def getAuthenticationType: ZIO[
      Any,
      Nothing,
      zio.aws.datasync.model.AzureBlobAuthenticationType
    ] = ZIO.succeed(authenticationType)
    def getSasConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.AzureBlobSasConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("sasConfiguration", sasConfiguration)
    def getBlobType: ZIO[Any, AwsError, zio.aws.datasync.model.AzureBlobType] =
      AwsError.unwrapOptionField("blobType", blobType)
    def getAccessTier
        : ZIO[Any, AwsError, zio.aws.datasync.model.AzureAccessTier] =
      AwsError.unwrapOptionField("accessTier", accessTier)
    def getSubdirectory: ZIO[Any, AwsError, AzureBlobSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getAgentArns: ZIO[Any, Nothing, List[AgentArn]] = ZIO.succeed(agentArns)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobRequest
  ) extends zio.aws.datasync.model.CreateLocationAzureBlobRequest.ReadOnly {
    override val containerUrl: AzureBlobContainerUrl =
      zio.aws.datasync.model.primitives
        .AzureBlobContainerUrl(impl.containerUrl())
    override val authenticationType
        : zio.aws.datasync.model.AzureBlobAuthenticationType =
      zio.aws.datasync.model.AzureBlobAuthenticationType
        .wrap(impl.authenticationType())
    override val sasConfiguration
        : Optional[zio.aws.datasync.model.AzureBlobSasConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sasConfiguration())
        .map(value =>
          zio.aws.datasync.model.AzureBlobSasConfiguration.wrap(value)
        )
    override val blobType: Optional[zio.aws.datasync.model.AzureBlobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blobType())
        .map(value => zio.aws.datasync.model.AzureBlobType.wrap(value))
    override val accessTier: Optional[zio.aws.datasync.model.AzureAccessTier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessTier())
        .map(value => zio.aws.datasync.model.AzureAccessTier.wrap(value))
    override val subdirectory: Optional[AzureBlobSubdirectory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subdirectory())
        .map(value =>
          zio.aws.datasync.model.primitives.AzureBlobSubdirectory(value)
        )
    override val agentArns: List[AgentArn] = impl
      .agentArns()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.AgentArn(item)
      }
      .toList
    override val tags
        : Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TagListEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationAzureBlobRequest
  ): zio.aws.datasync.model.CreateLocationAzureBlobRequest.ReadOnly =
    new Wrapper(impl)
}
