package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.FilterAttributeValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TaskFilter(
    name: zio.aws.datasync.model.TaskFilterName,
    values: Iterable[FilterAttributeValue],
    operator: zio.aws.datasync.model.Operator
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TaskFilter = {
    import TaskFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TaskFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterAttributeValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.TaskFilter.ReadOnly =
    zio.aws.datasync.model.TaskFilter.wrap(buildAwsValue())
}
object TaskFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TaskFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TaskFilter =
      zio.aws.datasync.model.TaskFilter(name, values, operator)
    def name: zio.aws.datasync.model.TaskFilterName
    def values: List[FilterAttributeValue]
    def operator: zio.aws.datasync.model.Operator
    def getName: ZIO[Any, Nothing, zio.aws.datasync.model.TaskFilterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterAttributeValue]] =
      ZIO.succeed(values)
    def getOperator: ZIO[Any, Nothing, zio.aws.datasync.model.Operator] =
      ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TaskFilter
  ) extends zio.aws.datasync.model.TaskFilter.ReadOnly {
    override val name: zio.aws.datasync.model.TaskFilterName =
      zio.aws.datasync.model.TaskFilterName.wrap(impl.name())
    override val values: List[FilterAttributeValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.FilterAttributeValue(item)
      }
      .toList
    override val operator: zio.aws.datasync.model.Operator =
      zio.aws.datasync.model.Operator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TaskFilter
  ): zio.aws.datasync.model.TaskFilter.ReadOnly = new Wrapper(impl)
}
