package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  NonNegativeLong,
  PtolemyString,
  PtolemyUUID
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetAppONTAPSVM(
    clusterUuid: Optional[PtolemyUUID] = Optional.Absent,
    resourceId: Optional[PtolemyUUID] = Optional.Absent,
    svmName: Optional[PtolemyString] = Optional.Absent,
    cifsShareCount: Optional[NonNegativeLong] = Optional.Absent,
    enabledProtocols: Optional[Iterable[PtolemyString]] = Optional.Absent,
    totalCapacityUsed: Optional[NonNegativeLong] = Optional.Absent,
    totalCapacityProvisioned: Optional[NonNegativeLong] = Optional.Absent,
    totalLogicalCapacityUsed: Optional[NonNegativeLong] = Optional.Absent,
    maxP95Performance: Optional[zio.aws.datasync.model.MaxP95Performance] =
      Optional.Absent,
    recommendations: Optional[Iterable[zio.aws.datasync.model.Recommendation]] =
      Optional.Absent,
    nfsExportedVolumes: Optional[NonNegativeLong] = Optional.Absent,
    recommendationStatus: Optional[
      zio.aws.datasync.model.RecommendationStatus
    ] = Optional.Absent,
    totalSnapshotCapacityUsed: Optional[NonNegativeLong] = Optional.Absent,
    lunCount: Optional[NonNegativeLong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.NetAppONTAPSVM = {
    import NetAppONTAPSVM.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.NetAppONTAPSVM
      .builder()
      .optionallyWith(
        clusterUuid.map(value => PtolemyUUID.unwrap(value): java.lang.String)
      )(_.clusterUuid)
      .optionallyWith(
        resourceId.map(value => PtolemyUUID.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        svmName.map(value => PtolemyString.unwrap(value): java.lang.String)
      )(_.svmName)
      .optionallyWith(
        cifsShareCount.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.cifsShareCount)
      .optionallyWith(
        enabledProtocols.map(value =>
          value.map { item =>
            PtolemyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.enabledProtocols)
      .optionallyWith(
        totalCapacityUsed.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.totalCapacityUsed)
      .optionallyWith(
        totalCapacityProvisioned.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.totalCapacityProvisioned)
      .optionallyWith(
        totalLogicalCapacityUsed.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.totalLogicalCapacityUsed)
      .optionallyWith(maxP95Performance.map(value => value.buildAwsValue()))(
        _.maxP95Performance
      )
      .optionallyWith(
        recommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendations)
      .optionallyWith(
        nfsExportedVolumes.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.nfsExportedVolumes)
      .optionallyWith(recommendationStatus.map(value => value.unwrap))(
        _.recommendationStatus
      )
      .optionallyWith(
        totalSnapshotCapacityUsed.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.totalSnapshotCapacityUsed)
      .optionallyWith(
        lunCount.map(value => NonNegativeLong.unwrap(value): java.lang.Long)
      )(_.lunCount)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.NetAppONTAPSVM.ReadOnly =
    zio.aws.datasync.model.NetAppONTAPSVM.wrap(buildAwsValue())
}
object NetAppONTAPSVM {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.NetAppONTAPSVM
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.NetAppONTAPSVM =
      zio.aws.datasync.model.NetAppONTAPSVM(
        clusterUuid.map(value => value),
        resourceId.map(value => value),
        svmName.map(value => value),
        cifsShareCount.map(value => value),
        enabledProtocols.map(value => value),
        totalCapacityUsed.map(value => value),
        totalCapacityProvisioned.map(value => value),
        totalLogicalCapacityUsed.map(value => value),
        maxP95Performance.map(value => value.asEditable),
        recommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nfsExportedVolumes.map(value => value),
        recommendationStatus.map(value => value),
        totalSnapshotCapacityUsed.map(value => value),
        lunCount.map(value => value)
      )
    def clusterUuid: Optional[PtolemyUUID]
    def resourceId: Optional[PtolemyUUID]
    def svmName: Optional[PtolemyString]
    def cifsShareCount: Optional[NonNegativeLong]
    def enabledProtocols: Optional[List[PtolemyString]]
    def totalCapacityUsed: Optional[NonNegativeLong]
    def totalCapacityProvisioned: Optional[NonNegativeLong]
    def totalLogicalCapacityUsed: Optional[NonNegativeLong]
    def maxP95Performance
        : Optional[zio.aws.datasync.model.MaxP95Performance.ReadOnly]
    def recommendations
        : Optional[List[zio.aws.datasync.model.Recommendation.ReadOnly]]
    def nfsExportedVolumes: Optional[NonNegativeLong]
    def recommendationStatus
        : Optional[zio.aws.datasync.model.RecommendationStatus]
    def totalSnapshotCapacityUsed: Optional[NonNegativeLong]
    def lunCount: Optional[NonNegativeLong]
    def getClusterUuid: ZIO[Any, AwsError, PtolemyUUID] =
      AwsError.unwrapOptionField("clusterUuid", clusterUuid)
    def getResourceId: ZIO[Any, AwsError, PtolemyUUID] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getSvmName: ZIO[Any, AwsError, PtolemyString] =
      AwsError.unwrapOptionField("svmName", svmName)
    def getCifsShareCount: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("cifsShareCount", cifsShareCount)
    def getEnabledProtocols: ZIO[Any, AwsError, List[PtolemyString]] =
      AwsError.unwrapOptionField("enabledProtocols", enabledProtocols)
    def getTotalCapacityUsed: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("totalCapacityUsed", totalCapacityUsed)
    def getTotalCapacityProvisioned: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField(
        "totalCapacityProvisioned",
        totalCapacityProvisioned
      )
    def getTotalLogicalCapacityUsed: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField(
        "totalLogicalCapacityUsed",
        totalLogicalCapacityUsed
      )
    def getMaxP95Performance: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.MaxP95Performance.ReadOnly
    ] = AwsError.unwrapOptionField("maxP95Performance", maxP95Performance)
    def getRecommendations: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.Recommendation.ReadOnly
    ]] = AwsError.unwrapOptionField("recommendations", recommendations)
    def getNfsExportedVolumes: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("nfsExportedVolumes", nfsExportedVolumes)
    def getRecommendationStatus
        : ZIO[Any, AwsError, zio.aws.datasync.model.RecommendationStatus] =
      AwsError.unwrapOptionField("recommendationStatus", recommendationStatus)
    def getTotalSnapshotCapacityUsed: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField(
        "totalSnapshotCapacityUsed",
        totalSnapshotCapacityUsed
      )
    def getLunCount: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("lunCount", lunCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.NetAppONTAPSVM
  ) extends zio.aws.datasync.model.NetAppONTAPSVM.ReadOnly {
    override val clusterUuid: Optional[PtolemyUUID] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterUuid())
      .map(value => zio.aws.datasync.model.primitives.PtolemyUUID(value))
    override val resourceId: Optional[PtolemyUUID] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.datasync.model.primitives.PtolemyUUID(value))
    override val svmName: Optional[PtolemyString] = zio.aws.core.internal
      .optionalFromNullable(impl.svmName())
      .map(value => zio.aws.datasync.model.primitives.PtolemyString(value))
    override val cifsShareCount: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cifsShareCount())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val enabledProtocols: Optional[List[PtolemyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enabledProtocols())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.primitives.PtolemyString(item)
          }.toList
        )
    override val totalCapacityUsed: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalCapacityUsed())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val totalCapacityProvisioned: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalCapacityProvisioned())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val totalLogicalCapacityUsed: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalLogicalCapacityUsed())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val maxP95Performance
        : Optional[zio.aws.datasync.model.MaxP95Performance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxP95Performance())
        .map(value => zio.aws.datasync.model.MaxP95Performance.wrap(value))
    override val recommendations
        : Optional[List[zio.aws.datasync.model.Recommendation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.Recommendation.wrap(item)
          }.toList
        )
    override val nfsExportedVolumes: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nfsExportedVolumes())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val recommendationStatus
        : Optional[zio.aws.datasync.model.RecommendationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationStatus())
        .map(value => zio.aws.datasync.model.RecommendationStatus.wrap(value))
    override val totalSnapshotCapacityUsed: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalSnapshotCapacityUsed())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val lunCount: Optional[NonNegativeLong] = zio.aws.core.internal
      .optionalFromNullable(impl.lunCount())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.NetAppONTAPSVM
  ): zio.aws.datasync.model.NetAppONTAPSVM.ReadOnly = new Wrapper(impl)
}
