package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeLocationFsxOpenZfsRequest(locationArn: LocationArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsRequest = {
    import DescribeLocationFsxOpenZfsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeLocationFsxOpenZfsRequest.ReadOnly =
    zio.aws.datasync.model.DescribeLocationFsxOpenZfsRequest
      .wrap(buildAwsValue())
}
object DescribeLocationFsxOpenZfsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationFsxOpenZfsRequest =
      zio.aws.datasync.model.DescribeLocationFsxOpenZfsRequest(locationArn)
    def locationArn: LocationArn
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsRequest
  ) extends zio.aws.datasync.model.DescribeLocationFsxOpenZfsRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsRequest
  ): zio.aws.datasync.model.DescribeLocationFsxOpenZfsRequest.ReadOnly =
    new Wrapper(impl)
}
