package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReportOverride(
    reportLevel: Optional[zio.aws.datasync.model.ReportLevel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ReportOverride = {
    import ReportOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ReportOverride
      .builder()
      .optionallyWith(reportLevel.map(value => value.unwrap))(_.reportLevel)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ReportOverride.ReadOnly =
    zio.aws.datasync.model.ReportOverride.wrap(buildAwsValue())
}
object ReportOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ReportOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ReportOverride =
      zio.aws.datasync.model.ReportOverride(reportLevel.map(value => value))
    def reportLevel: Optional[zio.aws.datasync.model.ReportLevel]
    def getReportLevel: ZIO[Any, AwsError, zio.aws.datasync.model.ReportLevel] =
      AwsError.unwrapOptionField("reportLevel", reportLevel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ReportOverride
  ) extends zio.aws.datasync.model.ReportOverride.ReadOnly {
    override val reportLevel: Optional[zio.aws.datasync.model.ReportLevel] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportLevel())
        .map(value => zio.aws.datasync.model.ReportLevel.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ReportOverride
  ): zio.aws.datasync.model.ReportOverride.ReadOnly = new Wrapper(impl)
}
