package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait ReportOutputType {
  def unwrap: software.amazon.awssdk.services.datasync.model.ReportOutputType
}
object ReportOutputType {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.ReportOutputType
  ): zio.aws.datasync.model.ReportOutputType = value match {
    case software.amazon.awssdk.services.datasync.model.ReportOutputType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.ReportOutputType.SUMMARY_ONLY =>
      val r = SUMMARY_ONLY
      r
    case software.amazon.awssdk.services.datasync.model.ReportOutputType.STANDARD =>
      val r = STANDARD
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.ReportOutputType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ReportOutputType =
      software.amazon.awssdk.services.datasync.model.ReportOutputType.UNKNOWN_TO_SDK_VERSION
  }
  case object SUMMARY_ONLY extends zio.aws.datasync.model.ReportOutputType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ReportOutputType =
      software.amazon.awssdk.services.datasync.model.ReportOutputType.SUMMARY_ONLY
  }
  case object STANDARD extends zio.aws.datasync.model.ReportOutputType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ReportOutputType =
      software.amazon.awssdk.services.datasync.model.ReportOutputType.STANDARD
  }
}
