package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait PhaseStatus {
  def unwrap: software.amazon.awssdk.services.datasync.model.PhaseStatus
}
object PhaseStatus {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.PhaseStatus
  ): zio.aws.datasync.model.PhaseStatus = value match {
    case software.amazon.awssdk.services.datasync.model.PhaseStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.PhaseStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.datasync.model.PhaseStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.datasync.model.PhaseStatus.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.PhaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.PhaseStatus =
      software.amazon.awssdk.services.datasync.model.PhaseStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.datasync.model.PhaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.PhaseStatus =
      software.amazon.awssdk.services.datasync.model.PhaseStatus.PENDING
  }
  case object SUCCESS extends zio.aws.datasync.model.PhaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.PhaseStatus =
      software.amazon.awssdk.services.datasync.model.PhaseStatus.SUCCESS
  }
  case object ERROR extends zio.aws.datasync.model.PhaseStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.PhaseStatus =
      software.amazon.awssdk.services.datasync.model.PhaseStatus.ERROR
  }
}
