package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  ErrorMessage,
  StorageSystemArn,
  Timestamp,
  SecretsManagerArn,
  LogGroupArn,
  Name,
  AgentArn
}
import scala.jdk.CollectionConverters.*
final case class DescribeStorageSystemResponse(
    storageSystemArn: Optional[StorageSystemArn] = Optional.Absent,
    serverConfiguration: Optional[
      zio.aws.datasync.model.DiscoveryServerConfiguration
    ] = Optional.Absent,
    systemType: Optional[zio.aws.datasync.model.DiscoverySystemType] =
      Optional.Absent,
    agentArns: Optional[Iterable[AgentArn]] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    connectivityStatus: Optional[
      zio.aws.datasync.model.StorageSystemConnectivityStatus
    ] = Optional.Absent,
    cloudWatchLogGroupArn: Optional[LogGroupArn] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    secretsManagerArn: Optional[SecretsManagerArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResponse = {
    import DescribeStorageSystemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResponse
      .builder()
      .optionallyWith(
        storageSystemArn.map(value =>
          StorageSystemArn.unwrap(value): java.lang.String
        )
      )(_.storageSystemArn)
      .optionallyWith(serverConfiguration.map(value => value.buildAwsValue()))(
        _.serverConfiguration
      )
      .optionallyWith(systemType.map(value => value.unwrap))(_.systemType)
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(connectivityStatus.map(value => value.unwrap))(
        _.connectivityStatus
      )
      .optionallyWith(
        cloudWatchLogGroupArn.map(value =>
          LogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupArn)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        secretsManagerArn.map(value =>
          SecretsManagerArn.unwrap(value): java.lang.String
        )
      )(_.secretsManagerArn)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeStorageSystemResponse.ReadOnly =
    zio.aws.datasync.model.DescribeStorageSystemResponse.wrap(buildAwsValue())
}
object DescribeStorageSystemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeStorageSystemResponse =
      zio.aws.datasync.model.DescribeStorageSystemResponse(
        storageSystemArn.map(value => value),
        serverConfiguration.map(value => value.asEditable),
        systemType.map(value => value),
        agentArns.map(value => value),
        name.map(value => value),
        errorMessage.map(value => value),
        connectivityStatus.map(value => value),
        cloudWatchLogGroupArn.map(value => value),
        creationTime.map(value => value),
        secretsManagerArn.map(value => value)
      )
    def storageSystemArn: Optional[StorageSystemArn]
    def serverConfiguration
        : Optional[zio.aws.datasync.model.DiscoveryServerConfiguration.ReadOnly]
    def systemType: Optional[zio.aws.datasync.model.DiscoverySystemType]
    def agentArns: Optional[List[AgentArn]]
    def name: Optional[Name]
    def errorMessage: Optional[ErrorMessage]
    def connectivityStatus
        : Optional[zio.aws.datasync.model.StorageSystemConnectivityStatus]
    def cloudWatchLogGroupArn: Optional[LogGroupArn]
    def creationTime: Optional[Timestamp]
    def secretsManagerArn: Optional[SecretsManagerArn]
    def getStorageSystemArn: ZIO[Any, AwsError, StorageSystemArn] =
      AwsError.unwrapOptionField("storageSystemArn", storageSystemArn)
    def getServerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.DiscoveryServerConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("serverConfiguration", serverConfiguration)
    def getSystemType
        : ZIO[Any, AwsError, zio.aws.datasync.model.DiscoverySystemType] =
      AwsError.unwrapOptionField("systemType", systemType)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getConnectivityStatus: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.StorageSystemConnectivityStatus
    ] = AwsError.unwrapOptionField("connectivityStatus", connectivityStatus)
    def getCloudWatchLogGroupArn: ZIO[Any, AwsError, LogGroupArn] =
      AwsError.unwrapOptionField("cloudWatchLogGroupArn", cloudWatchLogGroupArn)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getSecretsManagerArn: ZIO[Any, AwsError, SecretsManagerArn] =
      AwsError.unwrapOptionField("secretsManagerArn", secretsManagerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResponse
  ) extends zio.aws.datasync.model.DescribeStorageSystemResponse.ReadOnly {
    override val storageSystemArn: Optional[StorageSystemArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageSystemArn())
        .map(value => zio.aws.datasync.model.primitives.StorageSystemArn(value))
    override val serverConfiguration: Optional[
      zio.aws.datasync.model.DiscoveryServerConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverConfiguration())
      .map(value =>
        zio.aws.datasync.model.DiscoveryServerConfiguration.wrap(value)
      )
    override val systemType
        : Optional[zio.aws.datasync.model.DiscoverySystemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.systemType())
        .map(value => zio.aws.datasync.model.DiscoverySystemType.wrap(value))
    override val agentArns: Optional[List[AgentArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datasync.model.primitives.Name(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.datasync.model.primitives.ErrorMessage(value))
    override val connectivityStatus
        : Optional[zio.aws.datasync.model.StorageSystemConnectivityStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectivityStatus())
        .map(value =>
          zio.aws.datasync.model.StorageSystemConnectivityStatus.wrap(value)
        )
    override val cloudWatchLogGroupArn: Optional[LogGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupArn())
        .map(value => zio.aws.datasync.model.primitives.LogGroupArn(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Timestamp(value))
    override val secretsManagerArn: Optional[SecretsManagerArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secretsManagerArn())
        .map(value =>
          zio.aws.datasync.model.primitives.SecretsManagerArn(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResponse
  ): zio.aws.datasync.model.DescribeStorageSystemResponse.ReadOnly =
    new Wrapper(impl)
}
