package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  Ec2SecurityGroupArn,
  SmbUser,
  Time,
  LocationArn,
  SmbDomain,
  LocationUri
}
import scala.jdk.CollectionConverters.*
final case class DescribeLocationFsxWindowsResponse(
    locationArn: Optional[LocationArn] = Optional.Absent,
    locationUri: Optional[LocationUri] = Optional.Absent,
    securityGroupArns: Optional[Iterable[Ec2SecurityGroupArn]] =
      Optional.Absent,
    creationTime: Optional[Time] = Optional.Absent,
    user: Optional[SmbUser] = Optional.Absent,
    domain: Optional[SmbDomain] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsResponse = {
    import DescribeLocationFsxWindowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(
        securityGroupArns.map(value =>
          value.map { item =>
            Ec2SecurityGroupArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupArns)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        user.map(value => SmbUser.unwrap(value): java.lang.String)
      )(_.user)
      .optionallyWith(
        domain.map(value => SmbDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeLocationFsxWindowsResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationFsxWindowsResponse
      .wrap(buildAwsValue())
}
object DescribeLocationFsxWindowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationFsxWindowsResponse =
      zio.aws.datasync.model.DescribeLocationFsxWindowsResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        securityGroupArns.map(value => value),
        creationTime.map(value => value),
        user.map(value => value),
        domain.map(value => value)
      )
    def locationArn: Optional[LocationArn]
    def locationUri: Optional[LocationUri]
    def securityGroupArns: Optional[List[Ec2SecurityGroupArn]]
    def creationTime: Optional[Time]
    def user: Optional[SmbUser]
    def domain: Optional[SmbDomain]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getSecurityGroupArns: ZIO[Any, AwsError, List[Ec2SecurityGroupArn]] =
      AwsError.unwrapOptionField("securityGroupArns", securityGroupArns)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getUser: ZIO[Any, AwsError, SmbUser] =
      AwsError.unwrapOptionField("user", user)
    def getDomain: ZIO[Any, AwsError, SmbDomain] =
      AwsError.unwrapOptionField("domain", domain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsResponse
  ) extends zio.aws.datasync.model.DescribeLocationFsxWindowsResponse.ReadOnly {
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Optional[LocationUri] = zio.aws.core.internal
      .optionalFromNullable(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val securityGroupArns: Optional[List[Ec2SecurityGroupArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.primitives.Ec2SecurityGroupArn(item)
          }.toList
        )
    override val creationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
    override val user: Optional[SmbUser] = zio.aws.core.internal
      .optionalFromNullable(impl.user())
      .map(value => zio.aws.datasync.model.primitives.SmbUser(value))
    override val domain: Optional[SmbDomain] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.datasync.model.primitives.SmbDomain(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsResponse
  ): zio.aws.datasync.model.DescribeLocationFsxWindowsResponse.ReadOnly =
    new Wrapper(impl)
}
