package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait AzureBlobType {
  def unwrap: software.amazon.awssdk.services.datasync.model.AzureBlobType
}
object AzureBlobType {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.AzureBlobType
  ): zio.aws.datasync.model.AzureBlobType = value match {
    case software.amazon.awssdk.services.datasync.model.AzureBlobType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.AzureBlobType.BLOCK =>
      val r = BLOCK
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.AzureBlobType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.AzureBlobType =
      software.amazon.awssdk.services.datasync.model.AzureBlobType.UNKNOWN_TO_SDK_VERSION
  }
  case object BLOCK extends zio.aws.datasync.model.AzureBlobType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.AzureBlobType =
      software.amazon.awssdk.services.datasync.model.AzureBlobType.BLOCK
  }
}
