package zio.aws.datasync.model
import java.lang.Integer
import zio.aws.datasync.model.primitives.{
  CollectionDurationMinutes,
  DiscoveryJobArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateDiscoveryJobRequest(
    discoveryJobArn: DiscoveryJobArn,
    collectionDurationMinutes: CollectionDurationMinutes
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.UpdateDiscoveryJobRequest = {
    import UpdateDiscoveryJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.UpdateDiscoveryJobRequest
      .builder()
      .discoveryJobArn(
        DiscoveryJobArn.unwrap(discoveryJobArn): java.lang.String
      )
      .collectionDurationMinutes(
        CollectionDurationMinutes.unwrap(collectionDurationMinutes): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.UpdateDiscoveryJobRequest.ReadOnly =
    zio.aws.datasync.model.UpdateDiscoveryJobRequest.wrap(buildAwsValue())
}
object UpdateDiscoveryJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.UpdateDiscoveryJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.UpdateDiscoveryJobRequest =
      zio.aws.datasync.model
        .UpdateDiscoveryJobRequest(discoveryJobArn, collectionDurationMinutes)
    def discoveryJobArn: DiscoveryJobArn
    def collectionDurationMinutes: CollectionDurationMinutes
    def getDiscoveryJobArn: ZIO[Any, Nothing, DiscoveryJobArn] =
      ZIO.succeed(discoveryJobArn)
    def getCollectionDurationMinutes
        : ZIO[Any, Nothing, CollectionDurationMinutes] =
      ZIO.succeed(collectionDurationMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.UpdateDiscoveryJobRequest
  ) extends zio.aws.datasync.model.UpdateDiscoveryJobRequest.ReadOnly {
    override val discoveryJobArn: DiscoveryJobArn =
      zio.aws.datasync.model.primitives.DiscoveryJobArn(impl.discoveryJobArn())
    override val collectionDurationMinutes: CollectionDurationMinutes =
      zio.aws.datasync.model.primitives
        .CollectionDurationMinutes(impl.collectionDurationMinutes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.UpdateDiscoveryJobRequest
  ): zio.aws.datasync.model.UpdateDiscoveryJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
