package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReportResult(
    status: Optional[zio.aws.datasync.model.PhaseStatus] = Optional.Absent,
    errorCode: Optional[String] = Optional.Absent,
    errorDetail: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ReportResult = {
    import ReportResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ReportResult
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorDetail.map(value => value: java.lang.String))(
        _.errorDetail
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ReportResult.ReadOnly =
    zio.aws.datasync.model.ReportResult.wrap(buildAwsValue())
}
object ReportResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ReportResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ReportResult =
      zio.aws.datasync.model.ReportResult(
        status.map(value => value),
        errorCode.map(value => value),
        errorDetail.map(value => value)
      )
    def status: Optional[zio.aws.datasync.model.PhaseStatus]
    def errorCode: Optional[String]
    def errorDetail: Optional[String]
    def getStatus: ZIO[Any, AwsError, zio.aws.datasync.model.PhaseStatus] =
      AwsError.unwrapOptionField("status", status)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorDetail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorDetail", errorDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ReportResult
  ) extends zio.aws.datasync.model.ReportResult.ReadOnly {
    override val status: Optional[zio.aws.datasync.model.PhaseStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datasync.model.PhaseStatus.wrap(value))
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val errorDetail: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorDetail())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ReportResult
  ): zio.aws.datasync.model.ReportResult.ReadOnly = new Wrapper(impl)
}
