package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.AgentVersion
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Platform(version: Optional[AgentVersion] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.Platform = {
    import Platform.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.Platform
      .builder()
      .optionallyWith(
        version.map(value => AgentVersion.unwrap(value): java.lang.String)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.Platform.ReadOnly =
    zio.aws.datasync.model.Platform.wrap(buildAwsValue())
}
object Platform {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.datasync.model.Platform] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.Platform =
      zio.aws.datasync.model.Platform(version.map(value => value))
    def version: Optional[AgentVersion]
    def getVersion: ZIO[Any, AwsError, AgentVersion] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.Platform
  ) extends zio.aws.datasync.model.Platform.ReadOnly {
    override val version: Optional[AgentVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.datasync.model.primitives.AgentVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.Platform
  ): zio.aws.datasync.model.Platform.ReadOnly = new Wrapper(impl)
}
