package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  PtolemyBoolean,
  NonNegativeLong,
  PtolemyUUID,
  PtolemyString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NetAppONTAPVolume(
    volumeName: Optional[PtolemyString] = Optional.Absent,
    resourceId: Optional[PtolemyUUID] = Optional.Absent,
    cifsShareCount: Optional[NonNegativeLong] = Optional.Absent,
    securityStyle: Optional[PtolemyString] = Optional.Absent,
    svmUuid: Optional[PtolemyUUID] = Optional.Absent,
    svmName: Optional[PtolemyString] = Optional.Absent,
    capacityUsed: Optional[NonNegativeLong] = Optional.Absent,
    capacityProvisioned: Optional[NonNegativeLong] = Optional.Absent,
    logicalCapacityUsed: Optional[NonNegativeLong] = Optional.Absent,
    nfsExported: Optional[PtolemyBoolean] = Optional.Absent,
    snapshotCapacityUsed: Optional[NonNegativeLong] = Optional.Absent,
    maxP95Performance: Optional[zio.aws.datasync.model.MaxP95Performance] =
      Optional.Absent,
    recommendations: Optional[Iterable[zio.aws.datasync.model.Recommendation]] =
      Optional.Absent,
    recommendationStatus: Optional[
      zio.aws.datasync.model.RecommendationStatus
    ] = Optional.Absent,
    lunCount: Optional[NonNegativeLong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.NetAppONTAPVolume = {
    import NetAppONTAPVolume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.NetAppONTAPVolume
      .builder()
      .optionallyWith(
        volumeName.map(value => PtolemyString.unwrap(value): java.lang.String)
      )(_.volumeName)
      .optionallyWith(
        resourceId.map(value => PtolemyUUID.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        cifsShareCount.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.cifsShareCount)
      .optionallyWith(
        securityStyle.map(value =>
          PtolemyString.unwrap(value): java.lang.String
        )
      )(_.securityStyle)
      .optionallyWith(
        svmUuid.map(value => PtolemyUUID.unwrap(value): java.lang.String)
      )(_.svmUuid)
      .optionallyWith(
        svmName.map(value => PtolemyString.unwrap(value): java.lang.String)
      )(_.svmName)
      .optionallyWith(
        capacityUsed.map(value => NonNegativeLong.unwrap(value): java.lang.Long)
      )(_.capacityUsed)
      .optionallyWith(
        capacityProvisioned.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.capacityProvisioned)
      .optionallyWith(
        logicalCapacityUsed.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.logicalCapacityUsed)
      .optionallyWith(
        nfsExported.map(value =>
          PtolemyBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.nfsExported)
      .optionallyWith(
        snapshotCapacityUsed.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.snapshotCapacityUsed)
      .optionallyWith(maxP95Performance.map(value => value.buildAwsValue()))(
        _.maxP95Performance
      )
      .optionallyWith(
        recommendations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recommendations)
      .optionallyWith(recommendationStatus.map(value => value.unwrap))(
        _.recommendationStatus
      )
      .optionallyWith(
        lunCount.map(value => NonNegativeLong.unwrap(value): java.lang.Long)
      )(_.lunCount)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.NetAppONTAPVolume.ReadOnly =
    zio.aws.datasync.model.NetAppONTAPVolume.wrap(buildAwsValue())
}
object NetAppONTAPVolume {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.NetAppONTAPVolume
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.NetAppONTAPVolume =
      zio.aws.datasync.model.NetAppONTAPVolume(
        volumeName.map(value => value),
        resourceId.map(value => value),
        cifsShareCount.map(value => value),
        securityStyle.map(value => value),
        svmUuid.map(value => value),
        svmName.map(value => value),
        capacityUsed.map(value => value),
        capacityProvisioned.map(value => value),
        logicalCapacityUsed.map(value => value),
        nfsExported.map(value => value),
        snapshotCapacityUsed.map(value => value),
        maxP95Performance.map(value => value.asEditable),
        recommendations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recommendationStatus.map(value => value),
        lunCount.map(value => value)
      )
    def volumeName: Optional[PtolemyString]
    def resourceId: Optional[PtolemyUUID]
    def cifsShareCount: Optional[NonNegativeLong]
    def securityStyle: Optional[PtolemyString]
    def svmUuid: Optional[PtolemyUUID]
    def svmName: Optional[PtolemyString]
    def capacityUsed: Optional[NonNegativeLong]
    def capacityProvisioned: Optional[NonNegativeLong]
    def logicalCapacityUsed: Optional[NonNegativeLong]
    def nfsExported: Optional[PtolemyBoolean]
    def snapshotCapacityUsed: Optional[NonNegativeLong]
    def maxP95Performance
        : Optional[zio.aws.datasync.model.MaxP95Performance.ReadOnly]
    def recommendations
        : Optional[List[zio.aws.datasync.model.Recommendation.ReadOnly]]
    def recommendationStatus
        : Optional[zio.aws.datasync.model.RecommendationStatus]
    def lunCount: Optional[NonNegativeLong]
    def getVolumeName: ZIO[Any, AwsError, PtolemyString] =
      AwsError.unwrapOptionField("volumeName", volumeName)
    def getResourceId: ZIO[Any, AwsError, PtolemyUUID] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getCifsShareCount: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("cifsShareCount", cifsShareCount)
    def getSecurityStyle: ZIO[Any, AwsError, PtolemyString] =
      AwsError.unwrapOptionField("securityStyle", securityStyle)
    def getSvmUuid: ZIO[Any, AwsError, PtolemyUUID] =
      AwsError.unwrapOptionField("svmUuid", svmUuid)
    def getSvmName: ZIO[Any, AwsError, PtolemyString] =
      AwsError.unwrapOptionField("svmName", svmName)
    def getCapacityUsed: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("capacityUsed", capacityUsed)
    def getCapacityProvisioned: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("capacityProvisioned", capacityProvisioned)
    def getLogicalCapacityUsed: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("logicalCapacityUsed", logicalCapacityUsed)
    def getNfsExported: ZIO[Any, AwsError, PtolemyBoolean] =
      AwsError.unwrapOptionField("nfsExported", nfsExported)
    def getSnapshotCapacityUsed: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("snapshotCapacityUsed", snapshotCapacityUsed)
    def getMaxP95Performance: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.MaxP95Performance.ReadOnly
    ] = AwsError.unwrapOptionField("maxP95Performance", maxP95Performance)
    def getRecommendations: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.Recommendation.ReadOnly
    ]] = AwsError.unwrapOptionField("recommendations", recommendations)
    def getRecommendationStatus
        : ZIO[Any, AwsError, zio.aws.datasync.model.RecommendationStatus] =
      AwsError.unwrapOptionField("recommendationStatus", recommendationStatus)
    def getLunCount: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("lunCount", lunCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.NetAppONTAPVolume
  ) extends zio.aws.datasync.model.NetAppONTAPVolume.ReadOnly {
    override val volumeName: Optional[PtolemyString] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeName())
      .map(value => zio.aws.datasync.model.primitives.PtolemyString(value))
    override val resourceId: Optional[PtolemyUUID] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.datasync.model.primitives.PtolemyUUID(value))
    override val cifsShareCount: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cifsShareCount())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val securityStyle: Optional[PtolemyString] = zio.aws.core.internal
      .optionalFromNullable(impl.securityStyle())
      .map(value => zio.aws.datasync.model.primitives.PtolemyString(value))
    override val svmUuid: Optional[PtolemyUUID] = zio.aws.core.internal
      .optionalFromNullable(impl.svmUuid())
      .map(value => zio.aws.datasync.model.primitives.PtolemyUUID(value))
    override val svmName: Optional[PtolemyString] = zio.aws.core.internal
      .optionalFromNullable(impl.svmName())
      .map(value => zio.aws.datasync.model.primitives.PtolemyString(value))
    override val capacityUsed: Optional[NonNegativeLong] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityUsed())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val capacityProvisioned: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityProvisioned())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val logicalCapacityUsed: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logicalCapacityUsed())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val nfsExported: Optional[PtolemyBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.nfsExported())
      .map(value => zio.aws.datasync.model.primitives.PtolemyBoolean(value))
    override val snapshotCapacityUsed: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshotCapacityUsed())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val maxP95Performance
        : Optional[zio.aws.datasync.model.MaxP95Performance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxP95Performance())
        .map(value => zio.aws.datasync.model.MaxP95Performance.wrap(value))
    override val recommendations
        : Optional[List[zio.aws.datasync.model.Recommendation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.Recommendation.wrap(item)
          }.toList
        )
    override val recommendationStatus
        : Optional[zio.aws.datasync.model.RecommendationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendationStatus())
        .map(value => zio.aws.datasync.model.RecommendationStatus.wrap(value))
    override val lunCount: Optional[NonNegativeLong] = zio.aws.core.internal
      .optionalFromNullable(impl.lunCount())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.NetAppONTAPVolume
  ): zio.aws.datasync.model.NetAppONTAPVolume.ReadOnly = new Wrapper(impl)
}
