package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  DiscoveryJobArn,
  DiscoveryTime,
  DiscoveryMaxResults,
  DiscoveryNextToken,
  ResourceId
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeStorageSystemResourceMetricsRequest(
    discoveryJobArn: DiscoveryJobArn,
    resourceType: zio.aws.datasync.model.DiscoveryResourceType,
    resourceId: ResourceId,
    startTime: Optional[DiscoveryTime] = Optional.Absent,
    endTime: Optional[DiscoveryTime] = Optional.Absent,
    maxResults: Optional[DiscoveryMaxResults] = Optional.Absent,
    nextToken: Optional[DiscoveryNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest = {
    import DescribeStorageSystemResourceMetricsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest
      .builder()
      .discoveryJobArn(
        DiscoveryJobArn.unwrap(discoveryJobArn): java.lang.String
      )
      .resourceType(resourceType.unwrap)
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        startTime.map(value => DiscoveryTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => DiscoveryTime.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(
        maxResults.map(value => DiscoveryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          DiscoveryNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeStorageSystemResourceMetricsRequest.ReadOnly =
    zio.aws.datasync.model.DescribeStorageSystemResourceMetricsRequest
      .wrap(buildAwsValue())
}
object DescribeStorageSystemResourceMetricsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datasync.model.DescribeStorageSystemResourceMetricsRequest =
      zio.aws.datasync.model.DescribeStorageSystemResourceMetricsRequest(
        discoveryJobArn,
        resourceType,
        resourceId,
        startTime.map(value => value),
        endTime.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def discoveryJobArn: DiscoveryJobArn
    def resourceType: zio.aws.datasync.model.DiscoveryResourceType
    def resourceId: ResourceId
    def startTime: Optional[DiscoveryTime]
    def endTime: Optional[DiscoveryTime]
    def maxResults: Optional[DiscoveryMaxResults]
    def nextToken: Optional[DiscoveryNextToken]
    def getDiscoveryJobArn: ZIO[Any, Nothing, DiscoveryJobArn] =
      ZIO.succeed(discoveryJobArn)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.datasync.model.DiscoveryResourceType] =
      ZIO.succeed(resourceType)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getStartTime: ZIO[Any, AwsError, DiscoveryTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DiscoveryTime] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getMaxResults: ZIO[Any, AwsError, DiscoveryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, DiscoveryNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest
  ) extends zio.aws.datasync.model.DescribeStorageSystemResourceMetricsRequest.ReadOnly {
    override val discoveryJobArn: DiscoveryJobArn =
      zio.aws.datasync.model.primitives.DiscoveryJobArn(impl.discoveryJobArn())
    override val resourceType: zio.aws.datasync.model.DiscoveryResourceType =
      zio.aws.datasync.model.DiscoveryResourceType.wrap(impl.resourceType())
    override val resourceId: ResourceId =
      zio.aws.datasync.model.primitives.ResourceId(impl.resourceId())
    override val startTime: Optional[DiscoveryTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.datasync.model.primitives.DiscoveryTime(value))
    override val endTime: Optional[DiscoveryTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.datasync.model.primitives.DiscoveryTime(value))
    override val maxResults: Optional[DiscoveryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.datasync.model.primitives.DiscoveryMaxResults(value)
        )
    override val nextToken: Optional[DiscoveryNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.DiscoveryNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest
  ): zio.aws.datasync.model.DescribeStorageSystemResourceMetricsRequest.ReadOnly =
    new Wrapper(impl)
}
