package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.NonNegativeLong
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Capacity(
    used: Optional[NonNegativeLong] = Optional.Absent,
    provisioned: Optional[NonNegativeLong] = Optional.Absent,
    logicalUsed: Optional[NonNegativeLong] = Optional.Absent,
    clusterCloudStorageUsed: Optional[NonNegativeLong] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.Capacity = {
    import Capacity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.Capacity
      .builder()
      .optionallyWith(
        used.map(value => NonNegativeLong.unwrap(value): java.lang.Long)
      )(_.used)
      .optionallyWith(
        provisioned.map(value => NonNegativeLong.unwrap(value): java.lang.Long)
      )(_.provisioned)
      .optionallyWith(
        logicalUsed.map(value => NonNegativeLong.unwrap(value): java.lang.Long)
      )(_.logicalUsed)
      .optionallyWith(
        clusterCloudStorageUsed.map(value =>
          NonNegativeLong.unwrap(value): java.lang.Long
        )
      )(_.clusterCloudStorageUsed)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.Capacity.ReadOnly =
    zio.aws.datasync.model.Capacity.wrap(buildAwsValue())
}
object Capacity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.datasync.model.Capacity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.Capacity =
      zio.aws.datasync.model.Capacity(
        used.map(value => value),
        provisioned.map(value => value),
        logicalUsed.map(value => value),
        clusterCloudStorageUsed.map(value => value)
      )
    def used: Optional[NonNegativeLong]
    def provisioned: Optional[NonNegativeLong]
    def logicalUsed: Optional[NonNegativeLong]
    def clusterCloudStorageUsed: Optional[NonNegativeLong]
    def getUsed: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("used", used)
    def getProvisioned: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("provisioned", provisioned)
    def getLogicalUsed: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField("logicalUsed", logicalUsed)
    def getClusterCloudStorageUsed: ZIO[Any, AwsError, NonNegativeLong] =
      AwsError.unwrapOptionField(
        "clusterCloudStorageUsed",
        clusterCloudStorageUsed
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.Capacity
  ) extends zio.aws.datasync.model.Capacity.ReadOnly {
    override val used: Optional[NonNegativeLong] = zio.aws.core.internal
      .optionalFromNullable(impl.used())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val provisioned: Optional[NonNegativeLong] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioned())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val logicalUsed: Optional[NonNegativeLong] = zio.aws.core.internal
      .optionalFromNullable(impl.logicalUsed())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
    override val clusterCloudStorageUsed: Optional[NonNegativeLong] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterCloudStorageUsed())
        .map(value => zio.aws.datasync.model.primitives.NonNegativeLong(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.Capacity
  ): zio.aws.datasync.model.Capacity.ReadOnly = new Wrapper(impl)
}
