package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.AzureBlobSasToken
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AzureBlobSasConfiguration(token: AzureBlobSasToken) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.AzureBlobSasConfiguration = {
    import AzureBlobSasConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.AzureBlobSasConfiguration
      .builder()
      .token(AzureBlobSasToken.unwrap(token): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.AzureBlobSasConfiguration.ReadOnly =
    zio.aws.datasync.model.AzureBlobSasConfiguration.wrap(buildAwsValue())
}
object AzureBlobSasConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.AzureBlobSasConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.AzureBlobSasConfiguration =
      zio.aws.datasync.model.AzureBlobSasConfiguration(token)
    def token: AzureBlobSasToken
    def getToken: ZIO[Any, Nothing, AzureBlobSasToken] = ZIO.succeed(token)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.AzureBlobSasConfiguration
  ) extends zio.aws.datasync.model.AzureBlobSasConfiguration.ReadOnly {
    override val token: AzureBlobSasToken =
      zio.aws.datasync.model.primitives.AzureBlobSasToken(impl.token())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.AzureBlobSasConfiguration
  ): zio.aws.datasync.model.AzureBlobSasConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
