package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  PtolemyUUID,
  Name,
  LogGroupArn,
  AgentArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AddStorageSystemRequest(
    serverConfiguration: zio.aws.datasync.model.DiscoveryServerConfiguration,
    systemType: zio.aws.datasync.model.DiscoverySystemType,
    agentArns: Iterable[AgentArn],
    cloudWatchLogGroupArn: Optional[LogGroupArn] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.datasync.model.TagListEntry]] =
      Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    clientToken: PtolemyUUID,
    credentials: zio.aws.datasync.model.Credentials
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.AddStorageSystemRequest = {
    import AddStorageSystemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.AddStorageSystemRequest
      .builder()
      .serverConfiguration(serverConfiguration.buildAwsValue())
      .systemType(systemType.unwrap)
      .agentArns(agentArns.map { item =>
        AgentArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        cloudWatchLogGroupArn.map(value =>
          LogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .clientToken(PtolemyUUID.unwrap(clientToken): java.lang.String)
      .credentials(credentials.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.AddStorageSystemRequest.ReadOnly =
    zio.aws.datasync.model.AddStorageSystemRequest.wrap(buildAwsValue())
}
object AddStorageSystemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.AddStorageSystemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.AddStorageSystemRequest =
      zio.aws.datasync.model.AddStorageSystemRequest(
        serverConfiguration.asEditable,
        systemType,
        agentArns,
        cloudWatchLogGroupArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        name.map(value => value),
        clientToken,
        credentials.asEditable
      )
    def serverConfiguration
        : zio.aws.datasync.model.DiscoveryServerConfiguration.ReadOnly
    def systemType: zio.aws.datasync.model.DiscoverySystemType
    def agentArns: List[AgentArn]
    def cloudWatchLogGroupArn: Optional[LogGroupArn]
    def tags: Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def name: Optional[Name]
    def clientToken: PtolemyUUID
    def credentials: zio.aws.datasync.model.Credentials.ReadOnly
    def getServerConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.datasync.model.DiscoveryServerConfiguration.ReadOnly
    ] = ZIO.succeed(serverConfiguration)
    def getSystemType
        : ZIO[Any, Nothing, zio.aws.datasync.model.DiscoverySystemType] =
      ZIO.succeed(systemType)
    def getAgentArns: ZIO[Any, Nothing, List[AgentArn]] = ZIO.succeed(agentArns)
    def getCloudWatchLogGroupArn: ZIO[Any, AwsError, LogGroupArn] =
      AwsError.unwrapOptionField("cloudWatchLogGroupArn", cloudWatchLogGroupArn)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getClientToken: ZIO[Any, Nothing, PtolemyUUID] =
      ZIO.succeed(clientToken)
    def getCredentials
        : ZIO[Any, Nothing, zio.aws.datasync.model.Credentials.ReadOnly] =
      ZIO.succeed(credentials)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.AddStorageSystemRequest
  ) extends zio.aws.datasync.model.AddStorageSystemRequest.ReadOnly {
    override val serverConfiguration
        : zio.aws.datasync.model.DiscoveryServerConfiguration.ReadOnly =
      zio.aws.datasync.model.DiscoveryServerConfiguration
        .wrap(impl.serverConfiguration())
    override val systemType: zio.aws.datasync.model.DiscoverySystemType =
      zio.aws.datasync.model.DiscoverySystemType.wrap(impl.systemType())
    override val agentArns: List[AgentArn] = impl
      .agentArns()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.AgentArn(item)
      }
      .toList
    override val cloudWatchLogGroupArn: Optional[LogGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupArn())
        .map(value => zio.aws.datasync.model.primitives.LogGroupArn(value))
    override val tags
        : Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TagListEntry.wrap(item)
          }.toList
        )
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datasync.model.primitives.Name(value))
    override val clientToken: PtolemyUUID =
      zio.aws.datasync.model.primitives.PtolemyUUID(impl.clientToken())
    override val credentials: zio.aws.datasync.model.Credentials.ReadOnly =
      zio.aws.datasync.model.Credentials.wrap(impl.credentials())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.AddStorageSystemRequest
  ): zio.aws.datasync.model.AddStorageSystemRequest.ReadOnly = new Wrapper(impl)
}
