package zio.aws.datasync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  DiscoveryServerPort,
  DiscoveryServerHostname
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DiscoveryServerConfiguration(
    serverHostname: DiscoveryServerHostname,
    serverPort: Optional[DiscoveryServerPort] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DiscoveryServerConfiguration = {
    import DiscoveryServerConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DiscoveryServerConfiguration
      .builder()
      .serverHostname(
        DiscoveryServerHostname.unwrap(serverHostname): java.lang.String
      )
      .optionallyWith(
        serverPort.map(value => DiscoveryServerPort.unwrap(value): Integer)
      )(_.serverPort)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DiscoveryServerConfiguration.ReadOnly =
    zio.aws.datasync.model.DiscoveryServerConfiguration.wrap(buildAwsValue())
}
object DiscoveryServerConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DiscoveryServerConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DiscoveryServerConfiguration =
      zio.aws.datasync.model.DiscoveryServerConfiguration(
        serverHostname,
        serverPort.map(value => value)
      )
    def serverHostname: DiscoveryServerHostname
    def serverPort: Optional[DiscoveryServerPort]
    def getServerHostname: ZIO[Any, Nothing, DiscoveryServerHostname] =
      ZIO.succeed(serverHostname)
    def getServerPort: ZIO[Any, AwsError, DiscoveryServerPort] =
      AwsError.unwrapOptionField("serverPort", serverPort)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DiscoveryServerConfiguration
  ) extends zio.aws.datasync.model.DiscoveryServerConfiguration.ReadOnly {
    override val serverHostname: DiscoveryServerHostname =
      zio.aws.datasync.model.primitives
        .DiscoveryServerHostname(impl.serverHostname())
    override val serverPort: Optional[DiscoveryServerPort] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverPort())
        .map(value =>
          zio.aws.datasync.model.primitives.DiscoveryServerPort(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DiscoveryServerConfiguration
  ): zio.aws.datasync.model.DiscoveryServerConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
