package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait LogLevel {
  def unwrap: software.amazon.awssdk.services.datasync.model.LogLevel
}
object LogLevel {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.LogLevel
  ): zio.aws.datasync.model.LogLevel = value match {
    case software.amazon.awssdk.services.datasync.model.LogLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.LogLevel.OFF =>
      val r = OFF
      r
    case software.amazon.awssdk.services.datasync.model.LogLevel.BASIC =>
      val r = BASIC
      r
    case software.amazon.awssdk.services.datasync.model.LogLevel.TRANSFER =>
      val r = TRANSFER
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.LogLevel =
      software.amazon.awssdk.services.datasync.model.LogLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object OFF extends zio.aws.datasync.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.LogLevel =
      software.amazon.awssdk.services.datasync.model.LogLevel.OFF
  }
  case object BASIC extends zio.aws.datasync.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.LogLevel =
      software.amazon.awssdk.services.datasync.model.LogLevel.BASIC
  }
  case object TRANSFER extends zio.aws.datasync.model.LogLevel {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.LogLevel =
      software.amazon.awssdk.services.datasync.model.LogLevel.TRANSFER
  }
}
