package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait DiscoveryResourceFilter {
  def unwrap
      : software.amazon.awssdk.services.datasync.model.DiscoveryResourceFilter
}
object DiscoveryResourceFilter {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.DiscoveryResourceFilter
  ): zio.aws.datasync.model.DiscoveryResourceFilter = value match {
    case software.amazon.awssdk.services.datasync.model.DiscoveryResourceFilter.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.DiscoveryResourceFilter.SVM =>
      val r = SVM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.DiscoveryResourceFilter {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryResourceFilter =
      software.amazon.awssdk.services.datasync.model.DiscoveryResourceFilter.UNKNOWN_TO_SDK_VERSION
  }
  case object SVM extends zio.aws.datasync.model.DiscoveryResourceFilter {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryResourceFilter =
      software.amazon.awssdk.services.datasync.model.DiscoveryResourceFilter.SVM
  }
}
