package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.StorageSystemArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RemoveStorageSystemRequest(
    storageSystemArn: StorageSystemArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.RemoveStorageSystemRequest = {
    import RemoveStorageSystemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.RemoveStorageSystemRequest
      .builder()
      .storageSystemArn(
        StorageSystemArn.unwrap(storageSystemArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.RemoveStorageSystemRequest.ReadOnly =
    zio.aws.datasync.model.RemoveStorageSystemRequest.wrap(buildAwsValue())
}
object RemoveStorageSystemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.RemoveStorageSystemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.RemoveStorageSystemRequest =
      zio.aws.datasync.model.RemoveStorageSystemRequest(storageSystemArn)
    def storageSystemArn: StorageSystemArn
    def getStorageSystemArn: ZIO[Any, Nothing, StorageSystemArn] =
      ZIO.succeed(storageSystemArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.RemoveStorageSystemRequest
  ) extends zio.aws.datasync.model.RemoveStorageSystemRequest.ReadOnly {
    override val storageSystemArn: StorageSystemArn =
      zio.aws.datasync.model.primitives
        .StorageSystemArn(impl.storageSystemArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.RemoveStorageSystemRequest
  ): zio.aws.datasync.model.RemoveStorageSystemRequest.ReadOnly = new Wrapper(
    impl
  )
}
