package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  DiscoveryTime,
  CollectionDurationMinutes,
  DiscoveryJobArn,
  StorageSystemArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeDiscoveryJobResponse(
    storageSystemArn: Optional[StorageSystemArn] = Optional.Absent,
    discoveryJobArn: Optional[DiscoveryJobArn] = Optional.Absent,
    collectionDurationMinutes: Optional[CollectionDurationMinutes] =
      Optional.Absent,
    status: Optional[zio.aws.datasync.model.DiscoveryJobStatus] =
      Optional.Absent,
    jobStartTime: Optional[DiscoveryTime] = Optional.Absent,
    jobEndTime: Optional[DiscoveryTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobResponse = {
    import DescribeDiscoveryJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobResponse
      .builder()
      .optionallyWith(
        storageSystemArn.map(value =>
          StorageSystemArn.unwrap(value): java.lang.String
        )
      )(_.storageSystemArn)
      .optionallyWith(
        discoveryJobArn.map(value =>
          DiscoveryJobArn.unwrap(value): java.lang.String
        )
      )(_.discoveryJobArn)
      .optionallyWith(
        collectionDurationMinutes.map(value =>
          CollectionDurationMinutes.unwrap(value): Integer
        )
      )(_.collectionDurationMinutes)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        jobStartTime.map(value => DiscoveryTime.unwrap(value): Instant)
      )(_.jobStartTime)
      .optionallyWith(
        jobEndTime.map(value => DiscoveryTime.unwrap(value): Instant)
      )(_.jobEndTime)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeDiscoveryJobResponse.ReadOnly =
    zio.aws.datasync.model.DescribeDiscoveryJobResponse.wrap(buildAwsValue())
}
object DescribeDiscoveryJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeDiscoveryJobResponse =
      zio.aws.datasync.model.DescribeDiscoveryJobResponse(
        storageSystemArn.map(value => value),
        discoveryJobArn.map(value => value),
        collectionDurationMinutes.map(value => value),
        status.map(value => value),
        jobStartTime.map(value => value),
        jobEndTime.map(value => value)
      )
    def storageSystemArn: Optional[StorageSystemArn]
    def discoveryJobArn: Optional[DiscoveryJobArn]
    def collectionDurationMinutes: Optional[CollectionDurationMinutes]
    def status: Optional[zio.aws.datasync.model.DiscoveryJobStatus]
    def jobStartTime: Optional[DiscoveryTime]
    def jobEndTime: Optional[DiscoveryTime]
    def getStorageSystemArn: ZIO[Any, AwsError, StorageSystemArn] =
      AwsError.unwrapOptionField("storageSystemArn", storageSystemArn)
    def getDiscoveryJobArn: ZIO[Any, AwsError, DiscoveryJobArn] =
      AwsError.unwrapOptionField("discoveryJobArn", discoveryJobArn)
    def getCollectionDurationMinutes
        : ZIO[Any, AwsError, CollectionDurationMinutes] = AwsError
      .unwrapOptionField("collectionDurationMinutes", collectionDurationMinutes)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datasync.model.DiscoveryJobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getJobStartTime: ZIO[Any, AwsError, DiscoveryTime] =
      AwsError.unwrapOptionField("jobStartTime", jobStartTime)
    def getJobEndTime: ZIO[Any, AwsError, DiscoveryTime] =
      AwsError.unwrapOptionField("jobEndTime", jobEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobResponse
  ) extends zio.aws.datasync.model.DescribeDiscoveryJobResponse.ReadOnly {
    override val storageSystemArn: Optional[StorageSystemArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageSystemArn())
        .map(value => zio.aws.datasync.model.primitives.StorageSystemArn(value))
    override val discoveryJobArn: Optional[DiscoveryJobArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.discoveryJobArn())
        .map(value => zio.aws.datasync.model.primitives.DiscoveryJobArn(value))
    override val collectionDurationMinutes
        : Optional[CollectionDurationMinutes] = zio.aws.core.internal
      .optionalFromNullable(impl.collectionDurationMinutes())
      .map(value =>
        zio.aws.datasync.model.primitives.CollectionDurationMinutes(value)
      )
    override val status: Optional[zio.aws.datasync.model.DiscoveryJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datasync.model.DiscoveryJobStatus.wrap(value))
    override val jobStartTime: Optional[DiscoveryTime] = zio.aws.core.internal
      .optionalFromNullable(impl.jobStartTime())
      .map(value => zio.aws.datasync.model.primitives.DiscoveryTime(value))
    override val jobEndTime: Optional[DiscoveryTime] = zio.aws.core.internal
      .optionalFromNullable(impl.jobEndTime())
      .map(value => zio.aws.datasync.model.primitives.DiscoveryTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobResponse
  ): zio.aws.datasync.model.DescribeDiscoveryJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
