package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.AgentArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAgentRequest(agentArn: AgentArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DeleteAgentRequest = {
    import DeleteAgentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DeleteAgentRequest
      .builder()
      .agentArn(AgentArn.unwrap(agentArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DeleteAgentRequest.ReadOnly =
    zio.aws.datasync.model.DeleteAgentRequest.wrap(buildAwsValue())
}
object DeleteAgentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DeleteAgentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DeleteAgentRequest =
      zio.aws.datasync.model.DeleteAgentRequest(agentArn)
    def agentArn: AgentArn
    def getAgentArn: ZIO[Any, Nothing, AgentArn] = ZIO.succeed(agentArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DeleteAgentRequest
  ) extends zio.aws.datasync.model.DeleteAgentRequest.ReadOnly {
    override val agentArn: AgentArn =
      zio.aws.datasync.model.primitives.AgentArn(impl.agentArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DeleteAgentRequest
  ): zio.aws.datasync.model.DeleteAgentRequest.ReadOnly = new Wrapper(impl)
}
