package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{Name, StorageSystemArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StorageSystemListEntry(
    storageSystemArn: Optional[StorageSystemArn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.StorageSystemListEntry = {
    import StorageSystemListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.StorageSystemListEntry
      .builder()
      .optionallyWith(
        storageSystemArn.map(value =>
          StorageSystemArn.unwrap(value): java.lang.String
        )
      )(_.storageSystemArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.StorageSystemListEntry.ReadOnly =
    zio.aws.datasync.model.StorageSystemListEntry.wrap(buildAwsValue())
}
object StorageSystemListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.StorageSystemListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.StorageSystemListEntry =
      zio.aws.datasync.model.StorageSystemListEntry(
        storageSystemArn.map(value => value),
        name.map(value => value)
      )
    def storageSystemArn: Optional[StorageSystemArn]
    def name: Optional[Name]
    def getStorageSystemArn: ZIO[Any, AwsError, StorageSystemArn] =
      AwsError.unwrapOptionField("storageSystemArn", storageSystemArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.StorageSystemListEntry
  ) extends zio.aws.datasync.model.StorageSystemListEntry.ReadOnly {
    override val storageSystemArn: Optional[StorageSystemArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageSystemArn())
        .map(value => zio.aws.datasync.model.primitives.StorageSystemArn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datasync.model.primitives.Name(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.StorageSystemListEntry
  ): zio.aws.datasync.model.StorageSystemListEntry.ReadOnly = new Wrapper(impl)
}
