package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.DiscoveryJobArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartDiscoveryJobResponse(
    discoveryJobArn: Optional[DiscoveryJobArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.StartDiscoveryJobResponse = {
    import StartDiscoveryJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.StartDiscoveryJobResponse
      .builder()
      .optionallyWith(
        discoveryJobArn.map(value =>
          DiscoveryJobArn.unwrap(value): java.lang.String
        )
      )(_.discoveryJobArn)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.StartDiscoveryJobResponse.ReadOnly =
    zio.aws.datasync.model.StartDiscoveryJobResponse.wrap(buildAwsValue())
}
object StartDiscoveryJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.StartDiscoveryJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.StartDiscoveryJobResponse =
      zio.aws.datasync.model
        .StartDiscoveryJobResponse(discoveryJobArn.map(value => value))
    def discoveryJobArn: Optional[DiscoveryJobArn]
    def getDiscoveryJobArn: ZIO[Any, AwsError, DiscoveryJobArn] =
      AwsError.unwrapOptionField("discoveryJobArn", discoveryJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.StartDiscoveryJobResponse
  ) extends zio.aws.datasync.model.StartDiscoveryJobResponse.ReadOnly {
    override val discoveryJobArn: Optional[DiscoveryJobArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.discoveryJobArn())
        .map(value => zio.aws.datasync.model.primitives.DiscoveryJobArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.StartDiscoveryJobResponse
  ): zio.aws.datasync.model.StartDiscoveryJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
