package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait SmbVersion {
  def unwrap: software.amazon.awssdk.services.datasync.model.SmbVersion
}
object SmbVersion {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.SmbVersion
  ): zio.aws.datasync.model.SmbVersion = value match {
    case software.amazon.awssdk.services.datasync.model.SmbVersion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.SmbVersion.AUTOMATIC =>
      val r = AUTOMATIC
      r
    case software.amazon.awssdk.services.datasync.model.SmbVersion.SMB2 =>
      val r = SMB2
      r
    case software.amazon.awssdk.services.datasync.model.SmbVersion.SMB3 =>
      val r = SMB3
      r
    case software.amazon.awssdk.services.datasync.model.SmbVersion.SMB1 =>
      val r = SMB1
      r
    case software.amazon.awssdk.services.datasync.model.SmbVersion.SMB2_0 =>
      val r = SMB2_0
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.SmbVersion {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.SmbVersion =
      software.amazon.awssdk.services.datasync.model.SmbVersion.UNKNOWN_TO_SDK_VERSION
  }
  case object AUTOMATIC extends zio.aws.datasync.model.SmbVersion {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.SmbVersion =
      software.amazon.awssdk.services.datasync.model.SmbVersion.AUTOMATIC
  }
  case object SMB2 extends zio.aws.datasync.model.SmbVersion {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.SmbVersion =
      software.amazon.awssdk.services.datasync.model.SmbVersion.SMB2
  }
  case object SMB3 extends zio.aws.datasync.model.SmbVersion {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.SmbVersion =
      software.amazon.awssdk.services.datasync.model.SmbVersion.SMB3
  }
  case object SMB1 extends zio.aws.datasync.model.SmbVersion {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.SmbVersion =
      software.amazon.awssdk.services.datasync.model.SmbVersion.SMB1
  }
  case object SMB2_0 extends zio.aws.datasync.model.SmbVersion {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.SmbVersion =
      software.amazon.awssdk.services.datasync.model.SmbVersion.SMB2_0
  }
}
