package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait DiscoverySystemType {
  def unwrap: software.amazon.awssdk.services.datasync.model.DiscoverySystemType
}
object DiscoverySystemType {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.DiscoverySystemType
  ): zio.aws.datasync.model.DiscoverySystemType = value match {
    case software.amazon.awssdk.services.datasync.model.DiscoverySystemType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.DiscoverySystemType.NET_APP_ONTAP =>
      val r = NetAppONTAP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.DiscoverySystemType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoverySystemType =
      software.amazon.awssdk.services.datasync.model.DiscoverySystemType.UNKNOWN_TO_SDK_VERSION
  }
  case object NetAppONTAP extends zio.aws.datasync.model.DiscoverySystemType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoverySystemType =
      software.amazon.awssdk.services.datasync.model.DiscoverySystemType.NET_APP_ONTAP
  }
}
