package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.DiscoveryNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeStorageSystemResourceMetricsResponse(
    metrics: Optional[Iterable[zio.aws.datasync.model.ResourceMetrics]] =
      Optional.Absent,
    nextToken: Optional[DiscoveryNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsResponse = {
    import DescribeStorageSystemResourceMetricsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsResponse
      .builder()
      .optionallyWith(
        metrics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metrics)
      .optionallyWith(
        nextToken.map(value =>
          DiscoveryNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeStorageSystemResourceMetricsResponse.ReadOnly =
    zio.aws.datasync.model.DescribeStorageSystemResourceMetricsResponse
      .wrap(buildAwsValue())
}
object DescribeStorageSystemResourceMetricsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datasync.model.DescribeStorageSystemResourceMetricsResponse =
      zio.aws.datasync.model.DescribeStorageSystemResourceMetricsResponse(
        metrics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def metrics: Optional[List[zio.aws.datasync.model.ResourceMetrics.ReadOnly]]
    def nextToken: Optional[DiscoveryNextToken]
    def getMetrics: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.ResourceMetrics.ReadOnly
    ]] = AwsError.unwrapOptionField("metrics", metrics)
    def getNextToken: ZIO[Any, AwsError, DiscoveryNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsResponse
  ) extends zio.aws.datasync.model.DescribeStorageSystemResourceMetricsResponse.ReadOnly {
    override val metrics
        : Optional[List[zio.aws.datasync.model.ResourceMetrics.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metrics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.ResourceMetrics.wrap(item)
          }.toList
        )
    override val nextToken: Optional[DiscoveryNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.DiscoveryNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsResponse
  ): zio.aws.datasync.model.DescribeStorageSystemResourceMetricsResponse.ReadOnly =
    new Wrapper(impl)
}
