package zio.aws.datasync
import zio.aws.datasync.model.UpdateTaskResponse.ReadOnly
import zio.aws.datasync.model.{
  CancelTaskExecutionRequest,
  DescribeLocationFsxLustreRequest,
  StartDiscoveryJobRequest,
  UpdateLocationNfsRequest,
  DescribeStorageSystemRequest,
  CreateTaskRequest,
  CreateLocationSmbRequest,
  UpdateAgentRequest,
  CreateLocationFsxLustreRequest,
  ListStorageSystemsRequest,
  DeleteAgentRequest,
  DescribeLocationS3Request,
  DescribeLocationNfsRequest,
  UpdateLocationObjectStorageRequest,
  CreateLocationEfsRequest,
  UpdateLocationSmbRequest,
  ListTagsForResourceRequest,
  DescribeStorageSystemResourceMetricsRequest,
  DescribeTaskRequest,
  CreateLocationNfsRequest,
  DescribeLocationFsxWindowsRequest,
  ListLocationsRequest,
  CreateLocationFsxOntapRequest,
  StartTaskExecutionRequest,
  StopDiscoveryJobRequest,
  CreateLocationFsxOpenZfsRequest,
  GenerateRecommendationsRequest,
  DescribeLocationEfsRequest,
  DescribeLocationFsxOpenZfsRequest,
  DescribeStorageSystemResourcesRequest,
  CreateLocationS3Request,
  ListTasksRequest,
  DeleteTaskRequest,
  CreateLocationObjectStorageRequest,
  UpdateStorageSystemRequest,
  ListTaskExecutionsRequest,
  UpdateLocationHdfsRequest,
  AddStorageSystemRequest,
  UntagResourceRequest,
  DescribeLocationHdfsRequest,
  DescribeAgentRequest,
  DescribeDiscoveryJobRequest,
  RemoveStorageSystemRequest,
  UpdateDiscoveryJobRequest,
  CreateLocationHdfsRequest,
  CreateAgentRequest,
  CreateLocationFsxWindowsRequest,
  ListDiscoveryJobsRequest,
  DescribeLocationSmbRequest,
  DeleteLocationRequest,
  DescribeTaskExecutionRequest,
  DescribeLocationObjectStorageRequest,
  UpdateTaskExecutionRequest,
  ListAgentsRequest,
  UpdateTaskRequest,
  DescribeLocationFsxOntapRequest,
  TagResourceRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.datasync.model.{
  StartDiscoveryJobResponse,
  ListLocationsResponse,
  DescribeLocationObjectStorageResponse,
  CreateLocationNfsResponse,
  UpdateTaskExecutionResponse,
  DescribeDiscoveryJobResponse,
  ListTasksResponse,
  TaskListEntry,
  DescribeAgentResponse,
  DeleteLocationResponse,
  DescribeLocationFsxWindowsResponse,
  TagListEntry,
  CreateLocationS3Response,
  AddStorageSystemResponse,
  CreateLocationHdfsResponse,
  DescribeLocationSmbResponse,
  StorageSystemListEntry,
  UpdateAgentResponse,
  CancelTaskExecutionResponse,
  DescribeLocationFsxOpenZfsResponse,
  UpdateLocationNfsResponse,
  UpdateLocationHdfsResponse,
  GenerateRecommendationsResponse,
  TaskExecutionListEntry,
  CreateLocationSmbResponse,
  UpdateDiscoveryJobResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  CreateAgentResponse,
  UpdateStorageSystemResponse,
  DescribeLocationFsxLustreResponse,
  LocationListEntry,
  DescribeStorageSystemResponse,
  CreateLocationFsxOntapResponse,
  DeleteAgentResponse,
  DescribeTaskResponse,
  DiscoveryJobListEntry,
  DescribeStorageSystemResourceMetricsResponse,
  ResourceMetrics,
  DeleteTaskResponse,
  CreateLocationFsxOpenZfsResponse,
  UpdateLocationObjectStorageResponse,
  CreateLocationFsxLustreResponse,
  AgentListEntry,
  DescribeLocationFsxOntapResponse,
  DescribeLocationNfsResponse,
  ListTaskExecutionsResponse,
  CreateLocationEfsResponse,
  RemoveStorageSystemResponse,
  StopDiscoveryJobResponse,
  DescribeLocationHdfsResponse,
  DescribeTaskExecutionResponse,
  ListAgentsResponse,
  CreateTaskResponse,
  CreateLocationObjectStorageResponse,
  StartTaskExecutionResponse,
  UpdateTaskResponse,
  TagResourceResponse,
  ListStorageSystemsResponse,
  DescribeLocationS3Response,
  ListDiscoveryJobsResponse,
  DescribeStorageSystemResourcesResponse,
  UpdateLocationSmbResponse,
  DescribeLocationEfsResponse,
  CreateLocationFsxWindowsResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.datasync.{
  DataSyncAsyncClientBuilder,
  DataSyncAsyncClient
}
import scala.jdk.CollectionConverters.*
trait DataSync extends AspectSupport[DataSync] {
  val api: DataSyncAsyncClient
  def updateTaskExecution(
      request: UpdateTaskExecutionRequest
  ): IO[AwsError, zio.aws.datasync.model.UpdateTaskExecutionResponse.ReadOnly]
  def createLocationSmb(
      request: CreateLocationSmbRequest
  ): IO[AwsError, zio.aws.datasync.model.CreateLocationSmbResponse.ReadOnly]
  def describeStorageSystem(
      request: DescribeStorageSystemRequest
  ): IO[AwsError, zio.aws.datasync.model.DescribeStorageSystemResponse.ReadOnly]
  def listStorageSystems(request: ListStorageSystemsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.datasync.model.StorageSystemListEntry.ReadOnly
  ]
  def listStorageSystemsPaginated(
      request: ListStorageSystemsRequest
  ): IO[AwsError, zio.aws.datasync.model.ListStorageSystemsResponse.ReadOnly]
  def describeLocationSmb(
      request: DescribeLocationSmbRequest
  ): IO[AwsError, zio.aws.datasync.model.DescribeLocationSmbResponse.ReadOnly]
  def updateStorageSystem(
      request: UpdateStorageSystemRequest
  ): IO[AwsError, zio.aws.datasync.model.UpdateStorageSystemResponse.ReadOnly]
  def updateLocationHdfs(
      request: UpdateLocationHdfsRequest
  ): IO[AwsError, zio.aws.datasync.model.UpdateLocationHdfsResponse.ReadOnly]
  def createTask(
      request: CreateTaskRequest
  ): IO[AwsError, zio.aws.datasync.model.CreateTaskResponse.ReadOnly]
  def createAgent(
      request: CreateAgentRequest
  ): IO[AwsError, zio.aws.datasync.model.CreateAgentResponse.ReadOnly]
  def describeLocationFsxLustre(request: DescribeLocationFsxLustreRequest): IO[
    AwsError,
    zio.aws.datasync.model.DescribeLocationFsxLustreResponse.ReadOnly
  ]
  def startTaskExecution(
      request: StartTaskExecutionRequest
  ): IO[AwsError, zio.aws.datasync.model.StartTaskExecutionResponse.ReadOnly]
  def createLocationObjectStorage(
      request: CreateLocationObjectStorageRequest
  ): IO[
    AwsError,
    zio.aws.datasync.model.CreateLocationObjectStorageResponse.ReadOnly
  ]
  def deleteTask(
      request: DeleteTaskRequest
  ): IO[AwsError, zio.aws.datasync.model.DeleteTaskResponse.ReadOnly]
  def describeLocationS3(
      request: DescribeLocationS3Request
  ): IO[AwsError, zio.aws.datasync.model.DescribeLocationS3Response.ReadOnly]
  def createLocationFsxLustre(request: CreateLocationFsxLustreRequest): IO[
    AwsError,
    zio.aws.datasync.model.CreateLocationFsxLustreResponse.ReadOnly
  ]
  def createLocationNfs(
      request: CreateLocationNfsRequest
  ): IO[AwsError, zio.aws.datasync.model.CreateLocationNfsResponse.ReadOnly]
  def describeStorageSystemResources(
      request: DescribeStorageSystemResourcesRequest
  ): IO[
    AwsError,
    zio.aws.datasync.model.DescribeStorageSystemResourcesResponse.ReadOnly
  ]
  def createLocationFsxWindows(request: CreateLocationFsxWindowsRequest): IO[
    AwsError,
    zio.aws.datasync.model.CreateLocationFsxWindowsResponse.ReadOnly
  ]
  def updateLocationSmb(
      request: UpdateLocationSmbRequest
  ): IO[AwsError, zio.aws.datasync.model.UpdateLocationSmbResponse.ReadOnly]
  def cancelTaskExecution(
      request: CancelTaskExecutionRequest
  ): IO[AwsError, zio.aws.datasync.model.CancelTaskExecutionResponse.ReadOnly]
  def generateRecommendations(request: GenerateRecommendationsRequest): IO[
    AwsError,
    zio.aws.datasync.model.GenerateRecommendationsResponse.ReadOnly
  ]
  def describeAgent(
      request: DescribeAgentRequest
  ): IO[AwsError, zio.aws.datasync.model.DescribeAgentResponse.ReadOnly]
  def describeStorageSystemResourceMetrics(
      request: DescribeStorageSystemResourceMetricsRequest
  ): ZStream[Any, AwsError, zio.aws.datasync.model.ResourceMetrics.ReadOnly]
  def describeStorageSystemResourceMetricsPaginated(
      request: DescribeStorageSystemResourceMetricsRequest
  ): IO[
    AwsError,
    zio.aws.datasync.model.DescribeStorageSystemResourceMetricsResponse.ReadOnly
  ]
  def listLocations(
      request: ListLocationsRequest
  ): ZStream[Any, AwsError, zio.aws.datasync.model.LocationListEntry.ReadOnly]
  def listLocationsPaginated(
      request: ListLocationsRequest
  ): IO[AwsError, zio.aws.datasync.model.ListLocationsResponse.ReadOnly]
  def createLocationFsxOpenZfs(request: CreateLocationFsxOpenZfsRequest): IO[
    AwsError,
    zio.aws.datasync.model.CreateLocationFsxOpenZfsResponse.ReadOnly
  ]
  def describeLocationObjectStorage(
      request: DescribeLocationObjectStorageRequest
  ): IO[
    AwsError,
    zio.aws.datasync.model.DescribeLocationObjectStorageResponse.ReadOnly
  ]
  def describeLocationEfs(
      request: DescribeLocationEfsRequest
  ): IO[AwsError, zio.aws.datasync.model.DescribeLocationEfsResponse.ReadOnly]
  def updateLocationNfs(
      request: UpdateLocationNfsRequest
  ): IO[AwsError, zio.aws.datasync.model.UpdateLocationNfsResponse.ReadOnly]
  def listDiscoveryJobs(request: ListDiscoveryJobsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.datasync.model.DiscoveryJobListEntry.ReadOnly
  ]
  def listDiscoveryJobsPaginated(
      request: ListDiscoveryJobsRequest
  ): IO[AwsError, zio.aws.datasync.model.ListDiscoveryJobsResponse.ReadOnly]
  def stopDiscoveryJob(
      request: StopDiscoveryJobRequest
  ): IO[AwsError, zio.aws.datasync.model.StopDiscoveryJobResponse.ReadOnly]
  def removeStorageSystem(
      request: RemoveStorageSystemRequest
  ): IO[AwsError, zio.aws.datasync.model.RemoveStorageSystemResponse.ReadOnly]
  def describeLocationHdfs(
      request: DescribeLocationHdfsRequest
  ): IO[AwsError, zio.aws.datasync.model.DescribeLocationHdfsResponse.ReadOnly]
  def createLocationFsxOntap(request: CreateLocationFsxOntapRequest): IO[
    AwsError,
    zio.aws.datasync.model.CreateLocationFsxOntapResponse.ReadOnly
  ]
  def deleteLocation(
      request: DeleteLocationRequest
  ): IO[AwsError, zio.aws.datasync.model.DeleteLocationResponse.ReadOnly]
  def describeDiscoveryJob(
      request: DescribeDiscoveryJobRequest
  ): IO[AwsError, zio.aws.datasync.model.DescribeDiscoveryJobResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.datasync.model.UntagResourceResponse.ReadOnly]
  def describeTaskExecution(
      request: DescribeTaskExecutionRequest
  ): IO[AwsError, zio.aws.datasync.model.DescribeTaskExecutionResponse.ReadOnly]
  def createLocationS3(
      request: CreateLocationS3Request
  ): IO[AwsError, zio.aws.datasync.model.CreateLocationS3Response.ReadOnly]
  def updateTask(request: UpdateTaskRequest): IO[AwsError, ReadOnly]
  def listTaskExecutions(request: ListTaskExecutionsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly
  ]
  def listTaskExecutionsPaginated(
      request: ListTaskExecutionsRequest
  ): IO[AwsError, zio.aws.datasync.model.ListTaskExecutionsResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.datasync.model.TagListEntry.ReadOnly]
  def listTagsForResourcePaginated(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.datasync.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.datasync.model.TagResourceResponse.ReadOnly]
  def describeLocationFsxOpenZfs(
      request: DescribeLocationFsxOpenZfsRequest
  ): IO[
    AwsError,
    zio.aws.datasync.model.DescribeLocationFsxOpenZfsResponse.ReadOnly
  ]
  def addStorageSystem(
      request: AddStorageSystemRequest
  ): IO[AwsError, zio.aws.datasync.model.AddStorageSystemResponse.ReadOnly]
  def updateLocationObjectStorage(
      request: UpdateLocationObjectStorageRequest
  ): IO[
    AwsError,
    zio.aws.datasync.model.UpdateLocationObjectStorageResponse.ReadOnly
  ]
  def listTasks(
      request: ListTasksRequest
  ): ZStream[Any, AwsError, zio.aws.datasync.model.TaskListEntry.ReadOnly]
  def listTasksPaginated(
      request: ListTasksRequest
  ): IO[AwsError, zio.aws.datasync.model.ListTasksResponse.ReadOnly]
  def listAgents(
      request: ListAgentsRequest
  ): ZStream[Any, AwsError, zio.aws.datasync.model.AgentListEntry.ReadOnly]
  def listAgentsPaginated(
      request: ListAgentsRequest
  ): IO[AwsError, zio.aws.datasync.model.ListAgentsResponse.ReadOnly]
  def createLocationHdfs(
      request: CreateLocationHdfsRequest
  ): IO[AwsError, zio.aws.datasync.model.CreateLocationHdfsResponse.ReadOnly]
  def deleteAgent(
      request: DeleteAgentRequest
  ): IO[AwsError, zio.aws.datasync.model.DeleteAgentResponse.ReadOnly]
  def createLocationEfs(
      request: CreateLocationEfsRequest
  ): IO[AwsError, zio.aws.datasync.model.CreateLocationEfsResponse.ReadOnly]
  def describeLocationFsxWindows(
      request: DescribeLocationFsxWindowsRequest
  ): IO[
    AwsError,
    zio.aws.datasync.model.DescribeLocationFsxWindowsResponse.ReadOnly
  ]
  def describeTask(
      request: DescribeTaskRequest
  ): IO[AwsError, zio.aws.datasync.model.DescribeTaskResponse.ReadOnly]
  def updateAgent(
      request: UpdateAgentRequest
  ): IO[AwsError, zio.aws.datasync.model.UpdateAgentResponse.ReadOnly]
  def updateDiscoveryJob(
      request: UpdateDiscoveryJobRequest
  ): IO[AwsError, zio.aws.datasync.model.UpdateDiscoveryJobResponse.ReadOnly]
  def startDiscoveryJob(
      request: StartDiscoveryJobRequest
  ): IO[AwsError, zio.aws.datasync.model.StartDiscoveryJobResponse.ReadOnly]
  def describeLocationFsxOntap(request: DescribeLocationFsxOntapRequest): IO[
    AwsError,
    zio.aws.datasync.model.DescribeLocationFsxOntapResponse.ReadOnly
  ]
  def describeLocationNfs(
      request: DescribeLocationNfsRequest
  ): IO[AwsError, zio.aws.datasync.model.DescribeLocationNfsResponse.ReadOnly]
}
object DataSync {
  val live: ZLayer[AwsConfig, java.lang.Throwable, DataSync] = customized(
    identity
  )
  def customized(
      customization: DataSyncAsyncClientBuilder => DataSyncAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, DataSync] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: DataSyncAsyncClientBuilder => DataSyncAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, DataSync] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = DataSyncAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[DataSyncAsyncClient, DataSyncAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[DataSyncAsyncClient, DataSyncAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new DataSyncImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class DataSyncImpl[R](
      override val api: DataSyncAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends DataSync
      with AwsServiceBase[R] {
    override val serviceName: String = "DataSync"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DataSyncImpl[R1] = new DataSyncImpl(api, newAspect, r)
    def updateTaskExecution(request: UpdateTaskExecutionRequest): IO[
      AwsError,
      zio.aws.datasync.model.UpdateTaskExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.UpdateTaskExecutionRequest,
      UpdateTaskExecutionResponse
    ]("updateTaskExecution", api.updateTaskExecution)(request.buildAwsValue())
      .map(zio.aws.datasync.model.UpdateTaskExecutionResponse.wrap)
      .provideEnvironment(r)
    def createLocationSmb(
        request: CreateLocationSmbRequest
    ): IO[AwsError, zio.aws.datasync.model.CreateLocationSmbResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest,
        CreateLocationSmbResponse
      ]("createLocationSmb", api.createLocationSmb)(request.buildAwsValue())
        .map(zio.aws.datasync.model.CreateLocationSmbResponse.wrap)
        .provideEnvironment(r)
    def describeStorageSystem(request: DescribeStorageSystemRequest): IO[
      AwsError,
      zio.aws.datasync.model.DescribeStorageSystemResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeStorageSystemRequest,
      DescribeStorageSystemResponse
    ]("describeStorageSystem", api.describeStorageSystem)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.DescribeStorageSystemResponse.wrap)
      .provideEnvironment(r)
    def listStorageSystems(request: ListStorageSystemsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datasync.model.StorageSystemListEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest,
      ListStorageSystemsResponse,
      StorageSystemListEntry
    ](
      "listStorageSystems",
      api.listStorageSystems,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.storageSystems().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.datasync.model.StorageSystemListEntry.wrap(item))
      .provideEnvironment(r)
    def listStorageSystemsPaginated(request: ListStorageSystemsRequest): IO[
      AwsError,
      zio.aws.datasync.model.ListStorageSystemsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.ListStorageSystemsRequest,
      ListStorageSystemsResponse
    ]("listStorageSystems", api.listStorageSystems)(request.buildAwsValue())
      .map(zio.aws.datasync.model.ListStorageSystemsResponse.wrap)
      .provideEnvironment(r)
    def describeLocationSmb(request: DescribeLocationSmbRequest): IO[
      AwsError,
      zio.aws.datasync.model.DescribeLocationSmbResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeLocationSmbRequest,
      DescribeLocationSmbResponse
    ]("describeLocationSmb", api.describeLocationSmb)(request.buildAwsValue())
      .map(zio.aws.datasync.model.DescribeLocationSmbResponse.wrap)
      .provideEnvironment(r)
    def updateStorageSystem(request: UpdateStorageSystemRequest): IO[
      AwsError,
      zio.aws.datasync.model.UpdateStorageSystemResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.UpdateStorageSystemRequest,
      UpdateStorageSystemResponse
    ]("updateStorageSystem", api.updateStorageSystem)(request.buildAwsValue())
      .map(zio.aws.datasync.model.UpdateStorageSystemResponse.wrap)
      .provideEnvironment(r)
    def updateLocationHdfs(request: UpdateLocationHdfsRequest): IO[
      AwsError,
      zio.aws.datasync.model.UpdateLocationHdfsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.UpdateLocationHdfsRequest,
      UpdateLocationHdfsResponse
    ]("updateLocationHdfs", api.updateLocationHdfs)(request.buildAwsValue())
      .map(zio.aws.datasync.model.UpdateLocationHdfsResponse.wrap)
      .provideEnvironment(r)
    def createTask(
        request: CreateTaskRequest
    ): IO[AwsError, zio.aws.datasync.model.CreateTaskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.CreateTaskRequest,
        CreateTaskResponse
      ]("createTask", api.createTask)(request.buildAwsValue())
        .map(zio.aws.datasync.model.CreateTaskResponse.wrap)
        .provideEnvironment(r)
    def createAgent(
        request: CreateAgentRequest
    ): IO[AwsError, zio.aws.datasync.model.CreateAgentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.CreateAgentRequest,
        CreateAgentResponse
      ]("createAgent", api.createAgent)(request.buildAwsValue())
        .map(zio.aws.datasync.model.CreateAgentResponse.wrap)
        .provideEnvironment(r)
    def describeLocationFsxLustre(
        request: DescribeLocationFsxLustreRequest
    ): IO[
      AwsError,
      zio.aws.datasync.model.DescribeLocationFsxLustreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeLocationFsxLustreRequest,
      DescribeLocationFsxLustreResponse
    ]("describeLocationFsxLustre", api.describeLocationFsxLustre)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.DescribeLocationFsxLustreResponse.wrap)
      .provideEnvironment(r)
    def startTaskExecution(request: StartTaskExecutionRequest): IO[
      AwsError,
      zio.aws.datasync.model.StartTaskExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.StartTaskExecutionRequest,
      StartTaskExecutionResponse
    ]("startTaskExecution", api.startTaskExecution)(request.buildAwsValue())
      .map(zio.aws.datasync.model.StartTaskExecutionResponse.wrap)
      .provideEnvironment(r)
    def createLocationObjectStorage(
        request: CreateLocationObjectStorageRequest
    ): IO[
      AwsError,
      zio.aws.datasync.model.CreateLocationObjectStorageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.CreateLocationObjectStorageRequest,
      CreateLocationObjectStorageResponse
    ]("createLocationObjectStorage", api.createLocationObjectStorage)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.CreateLocationObjectStorageResponse.wrap)
      .provideEnvironment(r)
    def deleteTask(
        request: DeleteTaskRequest
    ): IO[AwsError, zio.aws.datasync.model.DeleteTaskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.DeleteTaskRequest,
        DeleteTaskResponse
      ]("deleteTask", api.deleteTask)(request.buildAwsValue())
        .map(zio.aws.datasync.model.DeleteTaskResponse.wrap)
        .provideEnvironment(r)
    def describeLocationS3(request: DescribeLocationS3Request): IO[
      AwsError,
      zio.aws.datasync.model.DescribeLocationS3Response.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeLocationS3Request,
      DescribeLocationS3Response
    ]("describeLocationS3", api.describeLocationS3)(request.buildAwsValue())
      .map(zio.aws.datasync.model.DescribeLocationS3Response.wrap)
      .provideEnvironment(r)
    def createLocationFsxLustre(request: CreateLocationFsxLustreRequest): IO[
      AwsError,
      zio.aws.datasync.model.CreateLocationFsxLustreResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.CreateLocationFsxLustreRequest,
      CreateLocationFsxLustreResponse
    ]("createLocationFsxLustre", api.createLocationFsxLustre)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.CreateLocationFsxLustreResponse.wrap)
      .provideEnvironment(r)
    def createLocationNfs(
        request: CreateLocationNfsRequest
    ): IO[AwsError, zio.aws.datasync.model.CreateLocationNfsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.CreateLocationNfsRequest,
        CreateLocationNfsResponse
      ]("createLocationNfs", api.createLocationNfs)(request.buildAwsValue())
        .map(zio.aws.datasync.model.CreateLocationNfsResponse.wrap)
        .provideEnvironment(r)
    def describeStorageSystemResources(
        request: DescribeStorageSystemResourcesRequest
    ): IO[
      AwsError,
      zio.aws.datasync.model.DescribeStorageSystemResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest,
      DescribeStorageSystemResourcesResponse
    ]("describeStorageSystemResources", api.describeStorageSystemResources)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.DescribeStorageSystemResourcesResponse.wrap)
      .provideEnvironment(r)
    def createLocationFsxWindows(request: CreateLocationFsxWindowsRequest): IO[
      AwsError,
      zio.aws.datasync.model.CreateLocationFsxWindowsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.CreateLocationFsxWindowsRequest,
      CreateLocationFsxWindowsResponse
    ]("createLocationFsxWindows", api.createLocationFsxWindows)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.CreateLocationFsxWindowsResponse.wrap)
      .provideEnvironment(r)
    def updateLocationSmb(
        request: UpdateLocationSmbRequest
    ): IO[AwsError, zio.aws.datasync.model.UpdateLocationSmbResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.UpdateLocationSmbRequest,
        UpdateLocationSmbResponse
      ]("updateLocationSmb", api.updateLocationSmb)(request.buildAwsValue())
        .map(zio.aws.datasync.model.UpdateLocationSmbResponse.wrap)
        .provideEnvironment(r)
    def cancelTaskExecution(request: CancelTaskExecutionRequest): IO[
      AwsError,
      zio.aws.datasync.model.CancelTaskExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.CancelTaskExecutionRequest,
      CancelTaskExecutionResponse
    ]("cancelTaskExecution", api.cancelTaskExecution)(request.buildAwsValue())
      .map(zio.aws.datasync.model.CancelTaskExecutionResponse.wrap)
      .provideEnvironment(r)
    def generateRecommendations(request: GenerateRecommendationsRequest): IO[
      AwsError,
      zio.aws.datasync.model.GenerateRecommendationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.GenerateRecommendationsRequest,
      GenerateRecommendationsResponse
    ]("generateRecommendations", api.generateRecommendations)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.GenerateRecommendationsResponse.wrap)
      .provideEnvironment(r)
    def describeAgent(
        request: DescribeAgentRequest
    ): IO[AwsError, zio.aws.datasync.model.DescribeAgentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.DescribeAgentRequest,
        DescribeAgentResponse
      ]("describeAgent", api.describeAgent)(request.buildAwsValue())
        .map(zio.aws.datasync.model.DescribeAgentResponse.wrap)
        .provideEnvironment(r)
    def describeStorageSystemResourceMetrics(
        request: DescribeStorageSystemResourceMetricsRequest
    ): ZStream[Any, AwsError, zio.aws.datasync.model.ResourceMetrics.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest,
        DescribeStorageSystemResourceMetricsResponse,
        ResourceMetrics
      ](
        "describeStorageSystemResourceMetrics",
        api.describeStorageSystemResourceMetrics,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.metrics().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.datasync.model.ResourceMetrics.wrap(item))
        .provideEnvironment(r)
    def describeStorageSystemResourceMetricsPaginated(
        request: DescribeStorageSystemResourceMetricsRequest
    ): IO[
      AwsError,
      zio.aws.datasync.model.DescribeStorageSystemResourceMetricsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourceMetricsRequest,
      DescribeStorageSystemResourceMetricsResponse
    ](
      "describeStorageSystemResourceMetrics",
      api.describeStorageSystemResourceMetrics
    )(request.buildAwsValue())
      .map(
        zio.aws.datasync.model.DescribeStorageSystemResourceMetricsResponse.wrap
      )
      .provideEnvironment(r)
    def listLocations(request: ListLocationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datasync.model.LocationListEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.datasync.model.ListLocationsRequest,
      ListLocationsResponse,
      LocationListEntry
    ](
      "listLocations",
      api.listLocations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.locations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.datasync.model.LocationListEntry.wrap(item))
      .provideEnvironment(r)
    def listLocationsPaginated(
        request: ListLocationsRequest
    ): IO[AwsError, zio.aws.datasync.model.ListLocationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.ListLocationsRequest,
        ListLocationsResponse
      ]("listLocations", api.listLocations)(request.buildAwsValue())
        .map(zio.aws.datasync.model.ListLocationsResponse.wrap)
        .provideEnvironment(r)
    def createLocationFsxOpenZfs(request: CreateLocationFsxOpenZfsRequest): IO[
      AwsError,
      zio.aws.datasync.model.CreateLocationFsxOpenZfsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.CreateLocationFsxOpenZfsRequest,
      CreateLocationFsxOpenZfsResponse
    ]("createLocationFsxOpenZfs", api.createLocationFsxOpenZfs)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.CreateLocationFsxOpenZfsResponse.wrap)
      .provideEnvironment(r)
    def describeLocationObjectStorage(
        request: DescribeLocationObjectStorageRequest
    ): IO[
      AwsError,
      zio.aws.datasync.model.DescribeLocationObjectStorageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeLocationObjectStorageRequest,
      DescribeLocationObjectStorageResponse
    ]("describeLocationObjectStorage", api.describeLocationObjectStorage)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.DescribeLocationObjectStorageResponse.wrap)
      .provideEnvironment(r)
    def describeLocationEfs(request: DescribeLocationEfsRequest): IO[
      AwsError,
      zio.aws.datasync.model.DescribeLocationEfsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeLocationEfsRequest,
      DescribeLocationEfsResponse
    ]("describeLocationEfs", api.describeLocationEfs)(request.buildAwsValue())
      .map(zio.aws.datasync.model.DescribeLocationEfsResponse.wrap)
      .provideEnvironment(r)
    def updateLocationNfs(
        request: UpdateLocationNfsRequest
    ): IO[AwsError, zio.aws.datasync.model.UpdateLocationNfsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.UpdateLocationNfsRequest,
        UpdateLocationNfsResponse
      ]("updateLocationNfs", api.updateLocationNfs)(request.buildAwsValue())
        .map(zio.aws.datasync.model.UpdateLocationNfsResponse.wrap)
        .provideEnvironment(r)
    def listDiscoveryJobs(request: ListDiscoveryJobsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datasync.model.DiscoveryJobListEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest,
      ListDiscoveryJobsResponse,
      DiscoveryJobListEntry
    ](
      "listDiscoveryJobs",
      api.listDiscoveryJobs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.discoveryJobs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.datasync.model.DiscoveryJobListEntry.wrap(item))
      .provideEnvironment(r)
    def listDiscoveryJobsPaginated(
        request: ListDiscoveryJobsRequest
    ): IO[AwsError, zio.aws.datasync.model.ListDiscoveryJobsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.ListDiscoveryJobsRequest,
        ListDiscoveryJobsResponse
      ]("listDiscoveryJobs", api.listDiscoveryJobs)(request.buildAwsValue())
        .map(zio.aws.datasync.model.ListDiscoveryJobsResponse.wrap)
        .provideEnvironment(r)
    def stopDiscoveryJob(
        request: StopDiscoveryJobRequest
    ): IO[AwsError, zio.aws.datasync.model.StopDiscoveryJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.StopDiscoveryJobRequest,
        StopDiscoveryJobResponse
      ]("stopDiscoveryJob", api.stopDiscoveryJob)(request.buildAwsValue())
        .map(zio.aws.datasync.model.StopDiscoveryJobResponse.wrap)
        .provideEnvironment(r)
    def removeStorageSystem(request: RemoveStorageSystemRequest): IO[
      AwsError,
      zio.aws.datasync.model.RemoveStorageSystemResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.RemoveStorageSystemRequest,
      RemoveStorageSystemResponse
    ]("removeStorageSystem", api.removeStorageSystem)(request.buildAwsValue())
      .map(zio.aws.datasync.model.RemoveStorageSystemResponse.wrap)
      .provideEnvironment(r)
    def describeLocationHdfs(request: DescribeLocationHdfsRequest): IO[
      AwsError,
      zio.aws.datasync.model.DescribeLocationHdfsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeLocationHdfsRequest,
      DescribeLocationHdfsResponse
    ]("describeLocationHdfs", api.describeLocationHdfs)(request.buildAwsValue())
      .map(zio.aws.datasync.model.DescribeLocationHdfsResponse.wrap)
      .provideEnvironment(r)
    def createLocationFsxOntap(request: CreateLocationFsxOntapRequest): IO[
      AwsError,
      zio.aws.datasync.model.CreateLocationFsxOntapResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapRequest,
      CreateLocationFsxOntapResponse
    ]("createLocationFsxOntap", api.createLocationFsxOntap)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.CreateLocationFsxOntapResponse.wrap)
      .provideEnvironment(r)
    def deleteLocation(
        request: DeleteLocationRequest
    ): IO[AwsError, zio.aws.datasync.model.DeleteLocationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.DeleteLocationRequest,
        DeleteLocationResponse
      ]("deleteLocation", api.deleteLocation)(request.buildAwsValue())
        .map(zio.aws.datasync.model.DeleteLocationResponse.wrap)
        .provideEnvironment(r)
    def describeDiscoveryJob(request: DescribeDiscoveryJobRequest): IO[
      AwsError,
      zio.aws.datasync.model.DescribeDiscoveryJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobRequest,
      DescribeDiscoveryJobResponse
    ]("describeDiscoveryJob", api.describeDiscoveryJob)(request.buildAwsValue())
      .map(zio.aws.datasync.model.DescribeDiscoveryJobResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.datasync.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.datasync.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeTaskExecution(request: DescribeTaskExecutionRequest): IO[
      AwsError,
      zio.aws.datasync.model.DescribeTaskExecutionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionRequest,
      DescribeTaskExecutionResponse
    ]("describeTaskExecution", api.describeTaskExecution)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.DescribeTaskExecutionResponse.wrap)
      .provideEnvironment(r)
    def createLocationS3(
        request: CreateLocationS3Request
    ): IO[AwsError, zio.aws.datasync.model.CreateLocationS3Response.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.CreateLocationS3Request,
        CreateLocationS3Response
      ]("createLocationS3", api.createLocationS3)(request.buildAwsValue())
        .map(zio.aws.datasync.model.CreateLocationS3Response.wrap)
        .provideEnvironment(r)
    def updateTask(request: UpdateTaskRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.UpdateTaskRequest,
        UpdateTaskResponse
      ]("updateTask", api.updateTask)(request.buildAwsValue())
        .map(zio.aws.datasync.model.UpdateTaskResponse.wrap)
        .provideEnvironment(r)
    def listTaskExecutions(request: ListTaskExecutionsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest,
      ListTaskExecutionsResponse,
      TaskExecutionListEntry
    ](
      "listTaskExecutions",
      api.listTaskExecutions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.taskExecutions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.datasync.model.TaskExecutionListEntry.wrap(item))
      .provideEnvironment(r)
    def listTaskExecutionsPaginated(request: ListTaskExecutionsRequest): IO[
      AwsError,
      zio.aws.datasync.model.ListTaskExecutionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.ListTaskExecutionsRequest,
      ListTaskExecutionsResponse
    ]("listTaskExecutions", api.listTaskExecutions)(request.buildAwsValue())
      .map(zio.aws.datasync.model.ListTaskExecutionsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
      Any,
      AwsError,
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse,
      TagListEntry
    ](
      "listTagsForResource",
      api.listTagsForResource,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.tags().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.datasync.model.TagListEntry.wrap(item))
      .provideEnvironment(r)
    def listTagsForResourcePaginated(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.datasync.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.datasync.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.datasync.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.datasync.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def describeLocationFsxOpenZfs(
        request: DescribeLocationFsxOpenZfsRequest
    ): IO[
      AwsError,
      zio.aws.datasync.model.DescribeLocationFsxOpenZfsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOpenZfsRequest,
      DescribeLocationFsxOpenZfsResponse
    ]("describeLocationFsxOpenZfs", api.describeLocationFsxOpenZfs)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.DescribeLocationFsxOpenZfsResponse.wrap)
      .provideEnvironment(r)
    def addStorageSystem(
        request: AddStorageSystemRequest
    ): IO[AwsError, zio.aws.datasync.model.AddStorageSystemResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.AddStorageSystemRequest,
        AddStorageSystemResponse
      ]("addStorageSystem", api.addStorageSystem)(request.buildAwsValue())
        .map(zio.aws.datasync.model.AddStorageSystemResponse.wrap)
        .provideEnvironment(r)
    def updateLocationObjectStorage(
        request: UpdateLocationObjectStorageRequest
    ): IO[
      AwsError,
      zio.aws.datasync.model.UpdateLocationObjectStorageResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.UpdateLocationObjectStorageRequest,
      UpdateLocationObjectStorageResponse
    ]("updateLocationObjectStorage", api.updateLocationObjectStorage)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.UpdateLocationObjectStorageResponse.wrap)
      .provideEnvironment(r)
    def listTasks(
        request: ListTasksRequest
    ): ZStream[Any, AwsError, zio.aws.datasync.model.TaskListEntry.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.datasync.model.ListTasksRequest,
        ListTasksResponse,
        TaskListEntry
      ](
        "listTasks",
        api.listTasks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tasks().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.datasync.model.TaskListEntry.wrap(item))
        .provideEnvironment(r)
    def listTasksPaginated(
        request: ListTasksRequest
    ): IO[AwsError, zio.aws.datasync.model.ListTasksResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.ListTasksRequest,
        ListTasksResponse
      ]("listTasks", api.listTasks)(request.buildAwsValue())
        .map(zio.aws.datasync.model.ListTasksResponse.wrap)
        .provideEnvironment(r)
    def listAgents(
        request: ListAgentsRequest
    ): ZStream[Any, AwsError, zio.aws.datasync.model.AgentListEntry.ReadOnly] =
      asyncSimplePaginatedRequest[
        software.amazon.awssdk.services.datasync.model.ListAgentsRequest,
        ListAgentsResponse,
        AgentListEntry
      ](
        "listAgents",
        api.listAgents,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.agents().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.datasync.model.AgentListEntry.wrap(item))
        .provideEnvironment(r)
    def listAgentsPaginated(
        request: ListAgentsRequest
    ): IO[AwsError, zio.aws.datasync.model.ListAgentsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.ListAgentsRequest,
        ListAgentsResponse
      ]("listAgents", api.listAgents)(request.buildAwsValue())
        .map(zio.aws.datasync.model.ListAgentsResponse.wrap)
        .provideEnvironment(r)
    def createLocationHdfs(request: CreateLocationHdfsRequest): IO[
      AwsError,
      zio.aws.datasync.model.CreateLocationHdfsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.CreateLocationHdfsRequest,
      CreateLocationHdfsResponse
    ]("createLocationHdfs", api.createLocationHdfs)(request.buildAwsValue())
      .map(zio.aws.datasync.model.CreateLocationHdfsResponse.wrap)
      .provideEnvironment(r)
    def deleteAgent(
        request: DeleteAgentRequest
    ): IO[AwsError, zio.aws.datasync.model.DeleteAgentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.DeleteAgentRequest,
        DeleteAgentResponse
      ]("deleteAgent", api.deleteAgent)(request.buildAwsValue())
        .map(zio.aws.datasync.model.DeleteAgentResponse.wrap)
        .provideEnvironment(r)
    def createLocationEfs(
        request: CreateLocationEfsRequest
    ): IO[AwsError, zio.aws.datasync.model.CreateLocationEfsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.CreateLocationEfsRequest,
        CreateLocationEfsResponse
      ]("createLocationEfs", api.createLocationEfs)(request.buildAwsValue())
        .map(zio.aws.datasync.model.CreateLocationEfsResponse.wrap)
        .provideEnvironment(r)
    def describeLocationFsxWindows(
        request: DescribeLocationFsxWindowsRequest
    ): IO[
      AwsError,
      zio.aws.datasync.model.DescribeLocationFsxWindowsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsRequest,
      DescribeLocationFsxWindowsResponse
    ]("describeLocationFsxWindows", api.describeLocationFsxWindows)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.DescribeLocationFsxWindowsResponse.wrap)
      .provideEnvironment(r)
    def describeTask(
        request: DescribeTaskRequest
    ): IO[AwsError, zio.aws.datasync.model.DescribeTaskResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.DescribeTaskRequest,
        DescribeTaskResponse
      ]("describeTask", api.describeTask)(request.buildAwsValue())
        .map(zio.aws.datasync.model.DescribeTaskResponse.wrap)
        .provideEnvironment(r)
    def updateAgent(
        request: UpdateAgentRequest
    ): IO[AwsError, zio.aws.datasync.model.UpdateAgentResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.UpdateAgentRequest,
        UpdateAgentResponse
      ]("updateAgent", api.updateAgent)(request.buildAwsValue())
        .map(zio.aws.datasync.model.UpdateAgentResponse.wrap)
        .provideEnvironment(r)
    def updateDiscoveryJob(request: UpdateDiscoveryJobRequest): IO[
      AwsError,
      zio.aws.datasync.model.UpdateDiscoveryJobResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.UpdateDiscoveryJobRequest,
      UpdateDiscoveryJobResponse
    ]("updateDiscoveryJob", api.updateDiscoveryJob)(request.buildAwsValue())
      .map(zio.aws.datasync.model.UpdateDiscoveryJobResponse.wrap)
      .provideEnvironment(r)
    def startDiscoveryJob(
        request: StartDiscoveryJobRequest
    ): IO[AwsError, zio.aws.datasync.model.StartDiscoveryJobResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.datasync.model.StartDiscoveryJobRequest,
        StartDiscoveryJobResponse
      ]("startDiscoveryJob", api.startDiscoveryJob)(request.buildAwsValue())
        .map(zio.aws.datasync.model.StartDiscoveryJobResponse.wrap)
        .provideEnvironment(r)
    def describeLocationFsxOntap(request: DescribeLocationFsxOntapRequest): IO[
      AwsError,
      zio.aws.datasync.model.DescribeLocationFsxOntapResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeLocationFsxOntapRequest,
      DescribeLocationFsxOntapResponse
    ]("describeLocationFsxOntap", api.describeLocationFsxOntap)(
      request.buildAwsValue()
    ).map(zio.aws.datasync.model.DescribeLocationFsxOntapResponse.wrap)
      .provideEnvironment(r)
    def describeLocationNfs(request: DescribeLocationNfsRequest): IO[
      AwsError,
      zio.aws.datasync.model.DescribeLocationNfsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.datasync.model.DescribeLocationNfsRequest,
      DescribeLocationNfsResponse
    ]("describeLocationNfs", api.describeLocationNfs)(request.buildAwsValue())
      .map(zio.aws.datasync.model.DescribeLocationNfsResponse.wrap)
      .provideEnvironment(r)
  }
  def updateTaskExecution(request: UpdateTaskExecutionRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.UpdateTaskExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTaskExecution(request))
  def createLocationSmb(request: CreateLocationSmbRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.CreateLocationSmbResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLocationSmb(request))
  def describeStorageSystem(request: DescribeStorageSystemRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeStorageSystemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStorageSystem(request))
  def listStorageSystems(request: ListStorageSystemsRequest): ZStream[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.StorageSystemListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listStorageSystems(request))
  def listStorageSystemsPaginated(request: ListStorageSystemsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.ListStorageSystemsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStorageSystemsPaginated(request))
  def describeLocationSmb(request: DescribeLocationSmbRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeLocationSmbResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLocationSmb(request))
  def updateStorageSystem(request: UpdateStorageSystemRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.UpdateStorageSystemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStorageSystem(request))
  def updateLocationHdfs(request: UpdateLocationHdfsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.UpdateLocationHdfsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLocationHdfs(request))
  def createTask(request: CreateTaskRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.CreateTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTask(request))
  def createAgent(request: CreateAgentRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.CreateAgentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAgent(request))
  def describeLocationFsxLustre(request: DescribeLocationFsxLustreRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeLocationFsxLustreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLocationFsxLustre(request))
  def startTaskExecution(request: StartTaskExecutionRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.StartTaskExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startTaskExecution(request))
  def createLocationObjectStorage(
      request: CreateLocationObjectStorageRequest
  ): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.CreateLocationObjectStorageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLocationObjectStorage(request))
  def deleteTask(request: DeleteTaskRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DeleteTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTask(request))
  def describeLocationS3(request: DescribeLocationS3Request): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeLocationS3Response.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLocationS3(request))
  def createLocationFsxLustre(request: CreateLocationFsxLustreRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.CreateLocationFsxLustreResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLocationFsxLustre(request))
  def createLocationNfs(request: CreateLocationNfsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.CreateLocationNfsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLocationNfs(request))
  def describeStorageSystemResources(
      request: DescribeStorageSystemResourcesRequest
  ): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeStorageSystemResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStorageSystemResources(request))
  def createLocationFsxWindows(request: CreateLocationFsxWindowsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.CreateLocationFsxWindowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLocationFsxWindows(request))
  def updateLocationSmb(request: UpdateLocationSmbRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.UpdateLocationSmbResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLocationSmb(request))
  def cancelTaskExecution(request: CancelTaskExecutionRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.CancelTaskExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelTaskExecution(request))
  def generateRecommendations(request: GenerateRecommendationsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.GenerateRecommendationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.generateRecommendations(request))
  def describeAgent(request: DescribeAgentRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeAgentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAgent(request))
  def describeStorageSystemResourceMetrics(
      request: DescribeStorageSystemResourceMetricsRequest
  ): ZStream[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.ResourceMetrics.ReadOnly
  ] = ZStream.serviceWithStream(_.describeStorageSystemResourceMetrics(request))
  def describeStorageSystemResourceMetricsPaginated(
      request: DescribeStorageSystemResourceMetricsRequest
  ): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeStorageSystemResourceMetricsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeStorageSystemResourceMetricsPaginated(request))
  def listLocations(request: ListLocationsRequest): ZStream[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.LocationListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listLocations(request))
  def listLocationsPaginated(request: ListLocationsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.ListLocationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLocationsPaginated(request))
  def createLocationFsxOpenZfs(request: CreateLocationFsxOpenZfsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.CreateLocationFsxOpenZfsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLocationFsxOpenZfs(request))
  def describeLocationObjectStorage(
      request: DescribeLocationObjectStorageRequest
  ): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeLocationObjectStorageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLocationObjectStorage(request))
  def describeLocationEfs(request: DescribeLocationEfsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeLocationEfsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLocationEfs(request))
  def updateLocationNfs(request: UpdateLocationNfsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.UpdateLocationNfsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLocationNfs(request))
  def listDiscoveryJobs(request: ListDiscoveryJobsRequest): ZStream[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DiscoveryJobListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listDiscoveryJobs(request))
  def listDiscoveryJobsPaginated(request: ListDiscoveryJobsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.ListDiscoveryJobsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDiscoveryJobsPaginated(request))
  def stopDiscoveryJob(request: StopDiscoveryJobRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.StopDiscoveryJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDiscoveryJob(request))
  def removeStorageSystem(request: RemoveStorageSystemRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.RemoveStorageSystemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeStorageSystem(request))
  def describeLocationHdfs(request: DescribeLocationHdfsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeLocationHdfsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLocationHdfs(request))
  def createLocationFsxOntap(request: CreateLocationFsxOntapRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.CreateLocationFsxOntapResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLocationFsxOntap(request))
  def deleteLocation(request: DeleteLocationRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DeleteLocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLocation(request))
  def describeDiscoveryJob(request: DescribeDiscoveryJobRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeDiscoveryJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDiscoveryJob(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def describeTaskExecution(request: DescribeTaskExecutionRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeTaskExecutionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTaskExecution(request))
  def createLocationS3(request: CreateLocationS3Request): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.CreateLocationS3Response.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLocationS3(request))
  def updateTask(
      request: UpdateTaskRequest
  ): ZIO[zio.aws.datasync.DataSync, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateTask(request))
  def listTaskExecutions(request: ListTaskExecutionsRequest): ZStream[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.TaskExecutionListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listTaskExecutions(request))
  def listTaskExecutionsPaginated(request: ListTaskExecutionsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.ListTaskExecutionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTaskExecutionsPaginated(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZStream[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.TagListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(request: ListTagsForResourceRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def describeLocationFsxOpenZfs(
      request: DescribeLocationFsxOpenZfsRequest
  ): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeLocationFsxOpenZfsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLocationFsxOpenZfs(request))
  def addStorageSystem(request: AddStorageSystemRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.AddStorageSystemResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addStorageSystem(request))
  def updateLocationObjectStorage(
      request: UpdateLocationObjectStorageRequest
  ): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.UpdateLocationObjectStorageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLocationObjectStorage(request))
  def listTasks(request: ListTasksRequest): ZStream[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.TaskListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listTasks(request))
  def listTasksPaginated(request: ListTasksRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.ListTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTasksPaginated(request))
  def listAgents(request: ListAgentsRequest): ZStream[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.AgentListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.listAgents(request))
  def listAgentsPaginated(request: ListAgentsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.ListAgentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAgentsPaginated(request))
  def createLocationHdfs(request: CreateLocationHdfsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.CreateLocationHdfsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLocationHdfs(request))
  def deleteAgent(request: DeleteAgentRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DeleteAgentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAgent(request))
  def createLocationEfs(request: CreateLocationEfsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.CreateLocationEfsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLocationEfs(request))
  def describeLocationFsxWindows(
      request: DescribeLocationFsxWindowsRequest
  ): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeLocationFsxWindowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLocationFsxWindows(request))
  def describeTask(request: DescribeTaskRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTask(request))
  def updateAgent(request: UpdateAgentRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.UpdateAgentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAgent(request))
  def updateDiscoveryJob(request: UpdateDiscoveryJobRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.UpdateDiscoveryJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDiscoveryJob(request))
  def startDiscoveryJob(request: StartDiscoveryJobRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.StartDiscoveryJobResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDiscoveryJob(request))
  def describeLocationFsxOntap(request: DescribeLocationFsxOntapRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeLocationFsxOntapResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLocationFsxOntap(request))
  def describeLocationNfs(request: DescribeLocationNfsRequest): ZIO[
    zio.aws.datasync.DataSync,
    AwsError,
    zio.aws.datasync.model.DescribeLocationNfsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLocationNfs(request))
}
