package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NfsMountOptions(
    version: Optional[zio.aws.datasync.model.NfsVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.NfsMountOptions = {
    import NfsMountOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.NfsMountOptions
      .builder()
      .optionallyWith(version.map(value => value.unwrap))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.NfsMountOptions.ReadOnly =
    zio.aws.datasync.model.NfsMountOptions.wrap(buildAwsValue())
}
object NfsMountOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.NfsMountOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.NfsMountOptions =
      zio.aws.datasync.model.NfsMountOptions(version.map(value => value))
    def version: Optional[zio.aws.datasync.model.NfsVersion]
    def getVersion: ZIO[Any, AwsError, zio.aws.datasync.model.NfsVersion] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.NfsMountOptions
  ) extends zio.aws.datasync.model.NfsMountOptions.ReadOnly {
    override val version: Optional[zio.aws.datasync.model.NfsVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.version())
        .map(value => zio.aws.datasync.model.NfsVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.NfsMountOptions
  ): zio.aws.datasync.model.NfsMountOptions.ReadOnly = new Wrapper(impl)
}
