package zio.aws.datasync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  PtolemyUUID,
  CollectionDurationMinutes,
  StorageSystemArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class StartDiscoveryJobRequest(
    storageSystemArn: StorageSystemArn,
    collectionDurationMinutes: CollectionDurationMinutes,
    clientToken: PtolemyUUID,
    tags: Optional[Iterable[zio.aws.datasync.model.TagListEntry]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.StartDiscoveryJobRequest = {
    import StartDiscoveryJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.StartDiscoveryJobRequest
      .builder()
      .storageSystemArn(
        StorageSystemArn.unwrap(storageSystemArn): java.lang.String
      )
      .collectionDurationMinutes(
        CollectionDurationMinutes.unwrap(collectionDurationMinutes): Integer
      )
      .clientToken(PtolemyUUID.unwrap(clientToken): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.StartDiscoveryJobRequest.ReadOnly =
    zio.aws.datasync.model.StartDiscoveryJobRequest.wrap(buildAwsValue())
}
object StartDiscoveryJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.StartDiscoveryJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.StartDiscoveryJobRequest =
      zio.aws.datasync.model.StartDiscoveryJobRequest(
        storageSystemArn,
        collectionDurationMinutes,
        clientToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def storageSystemArn: StorageSystemArn
    def collectionDurationMinutes: CollectionDurationMinutes
    def clientToken: PtolemyUUID
    def tags: Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def getStorageSystemArn: ZIO[Any, Nothing, StorageSystemArn] =
      ZIO.succeed(storageSystemArn)
    def getCollectionDurationMinutes
        : ZIO[Any, Nothing, CollectionDurationMinutes] =
      ZIO.succeed(collectionDurationMinutes)
    def getClientToken: ZIO[Any, Nothing, PtolemyUUID] =
      ZIO.succeed(clientToken)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.StartDiscoveryJobRequest
  ) extends zio.aws.datasync.model.StartDiscoveryJobRequest.ReadOnly {
    override val storageSystemArn: StorageSystemArn =
      zio.aws.datasync.model.primitives
        .StorageSystemArn(impl.storageSystemArn())
    override val collectionDurationMinutes: CollectionDurationMinutes =
      zio.aws.datasync.model.primitives
        .CollectionDurationMinutes(impl.collectionDurationMinutes())
    override val clientToken: PtolemyUUID =
      zio.aws.datasync.model.primitives.PtolemyUUID(impl.clientToken())
    override val tags
        : Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TagListEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.StartDiscoveryJobRequest
  ): zio.aws.datasync.model.StartDiscoveryJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
