package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  Time,
  AgentArn,
  LocationUri,
  LocationArn
}
import scala.jdk.CollectionConverters.*
final case class DescribeLocationAzureBlobResponse(
    locationArn: Optional[LocationArn] = Optional.Absent,
    locationUri: Optional[LocationUri] = Optional.Absent,
    authenticationType: Optional[
      zio.aws.datasync.model.AzureBlobAuthenticationType
    ] = Optional.Absent,
    blobType: Optional[zio.aws.datasync.model.AzureBlobType] = Optional.Absent,
    accessTier: Optional[zio.aws.datasync.model.AzureAccessTier] =
      Optional.Absent,
    agentArns: Optional[Iterable[AgentArn]] = Optional.Absent,
    creationTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobResponse = {
    import DescribeLocationAzureBlobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .optionallyWith(
        locationUri.map(value => LocationUri.unwrap(value): java.lang.String)
      )(_.locationUri)
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(blobType.map(value => value.unwrap))(_.blobType)
      .optionallyWith(accessTier.map(value => value.unwrap))(_.accessTier)
      .optionallyWith(
        agentArns.map(value =>
          value.map { item =>
            AgentArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.agentArns)
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeLocationAzureBlobResponse.ReadOnly =
    zio.aws.datasync.model.DescribeLocationAzureBlobResponse
      .wrap(buildAwsValue())
}
object DescribeLocationAzureBlobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationAzureBlobResponse =
      zio.aws.datasync.model.DescribeLocationAzureBlobResponse(
        locationArn.map(value => value),
        locationUri.map(value => value),
        authenticationType.map(value => value),
        blobType.map(value => value),
        accessTier.map(value => value),
        agentArns.map(value => value),
        creationTime.map(value => value)
      )
    def locationArn: Optional[LocationArn]
    def locationUri: Optional[LocationUri]
    def authenticationType
        : Optional[zio.aws.datasync.model.AzureBlobAuthenticationType]
    def blobType: Optional[zio.aws.datasync.model.AzureBlobType]
    def accessTier: Optional[zio.aws.datasync.model.AzureAccessTier]
    def agentArns: Optional[List[AgentArn]]
    def creationTime: Optional[Time]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
    def getLocationUri: ZIO[Any, AwsError, LocationUri] =
      AwsError.unwrapOptionField("locationUri", locationUri)
    def getAuthenticationType: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.AzureBlobAuthenticationType
    ] = AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getBlobType: ZIO[Any, AwsError, zio.aws.datasync.model.AzureBlobType] =
      AwsError.unwrapOptionField("blobType", blobType)
    def getAccessTier
        : ZIO[Any, AwsError, zio.aws.datasync.model.AzureAccessTier] =
      AwsError.unwrapOptionField("accessTier", accessTier)
    def getAgentArns: ZIO[Any, AwsError, List[AgentArn]] =
      AwsError.unwrapOptionField("agentArns", agentArns)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobResponse
  ) extends zio.aws.datasync.model.DescribeLocationAzureBlobResponse.ReadOnly {
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val locationUri: Optional[LocationUri] = zio.aws.core.internal
      .optionalFromNullable(impl.locationUri())
      .map(value => zio.aws.datasync.model.primitives.LocationUri(value))
    override val authenticationType
        : Optional[zio.aws.datasync.model.AzureBlobAuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value =>
          zio.aws.datasync.model.AzureBlobAuthenticationType.wrap(value)
        )
    override val blobType: Optional[zio.aws.datasync.model.AzureBlobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blobType())
        .map(value => zio.aws.datasync.model.AzureBlobType.wrap(value))
    override val accessTier: Optional[zio.aws.datasync.model.AzureAccessTier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accessTier())
        .map(value => zio.aws.datasync.model.AzureAccessTier.wrap(value))
    override val agentArns: Optional[List[AgentArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.agentArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.AgentArn(item)
        }.toList
      )
    override val creationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationAzureBlobResponse
  ): zio.aws.datasync.model.DescribeLocationAzureBlobResponse.ReadOnly =
    new Wrapper(impl)
}
