package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.DiscoveryJobArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeDiscoveryJobRequest(discoveryJobArn: DiscoveryJobArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobRequest = {
    import DescribeDiscoveryJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobRequest
      .builder()
      .discoveryJobArn(
        DiscoveryJobArn.unwrap(discoveryJobArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeDiscoveryJobRequest.ReadOnly =
    zio.aws.datasync.model.DescribeDiscoveryJobRequest.wrap(buildAwsValue())
}
object DescribeDiscoveryJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeDiscoveryJobRequest =
      zio.aws.datasync.model.DescribeDiscoveryJobRequest(discoveryJobArn)
    def discoveryJobArn: DiscoveryJobArn
    def getDiscoveryJobArn: ZIO[Any, Nothing, DiscoveryJobArn] =
      ZIO.succeed(discoveryJobArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobRequest
  ) extends zio.aws.datasync.model.DescribeDiscoveryJobRequest.ReadOnly {
    override val discoveryJobArn: DiscoveryJobArn =
      zio.aws.datasync.model.primitives.DiscoveryJobArn(impl.discoveryJobArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeDiscoveryJobRequest
  ): zio.aws.datasync.model.DescribeDiscoveryJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
