package zio.aws.datasync
import zio.aws.datasync.model.primitives.ServerHostname.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.datasync.model.primitives.{
  Ec2SecurityGroupArn,
  FilterAttributeValue,
  Ec2SubnetArn,
  NetworkInterfaceArn,
  AgentArn,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ActivationKey extends Subtype[String]
    type ActivationKey = zio.aws.datasync.model.primitives.ActivationKey.Type
    object AgentArn extends Subtype[String]
    type AgentArn = zio.aws.datasync.model.primitives.AgentArn.Type
    object BytesPerSecond extends Subtype[Long]
    type BytesPerSecond = zio.aws.datasync.model.primitives.BytesPerSecond.Type
    object Duration extends Subtype[Long]
    type Duration = zio.aws.datasync.model.primitives.Duration.Type
    object Ec2SecurityGroupArn extends Subtype[String]
    type Ec2SecurityGroupArn =
      zio.aws.datasync.model.primitives.Ec2SecurityGroupArn.Type
    object Ec2SubnetArn extends Subtype[String]
    type Ec2SubnetArn = zio.aws.datasync.model.primitives.Ec2SubnetArn.Type
    object EfsAccessPointArn extends Subtype[String]
    type EfsAccessPointArn =
      zio.aws.datasync.model.primitives.EfsAccessPointArn.Type
    object EfsFilesystemArn extends Subtype[String]
    type EfsFilesystemArn =
      zio.aws.datasync.model.primitives.EfsFilesystemArn.Type
    object EfsSubdirectory extends Subtype[String]
    type EfsSubdirectory =
      zio.aws.datasync.model.primitives.EfsSubdirectory.Type
    object Endpoint extends Subtype[String]
    type Endpoint = zio.aws.datasync.model.primitives.Endpoint.Type
    object FilterAttributeValue extends Subtype[String]
    type FilterAttributeValue =
      zio.aws.datasync.model.primitives.FilterAttributeValue.Type
    object FilterValue extends Subtype[String]
    type FilterValue = zio.aws.datasync.model.primitives.FilterValue.Type
    object FsxFilesystemArn extends Subtype[String]
    type FsxFilesystemArn =
      zio.aws.datasync.model.primitives.FsxFilesystemArn.Type
    object FsxLustreSubdirectory extends Subtype[String]
    type FsxLustreSubdirectory =
      zio.aws.datasync.model.primitives.FsxLustreSubdirectory.Type
    object FsxOntapSubdirectory extends Subtype[String]
    type FsxOntapSubdirectory =
      zio.aws.datasync.model.primitives.FsxOntapSubdirectory.Type
    object FsxOpenZfsSubdirectory extends Subtype[String]
    type FsxOpenZfsSubdirectory =
      zio.aws.datasync.model.primitives.FsxOpenZfsSubdirectory.Type
    object FsxWindowsSubdirectory extends Subtype[String]
    type FsxWindowsSubdirectory =
      zio.aws.datasync.model.primitives.FsxWindowsSubdirectory.Type
    object HdfsBlockSize extends Subtype[Int]
    type HdfsBlockSize = zio.aws.datasync.model.primitives.HdfsBlockSize.Type
    object HdfsReplicationFactor extends Subtype[Int]
    type HdfsReplicationFactor =
      zio.aws.datasync.model.primitives.HdfsReplicationFactor.Type
    object HdfsServerHostname extends Subtype[String]
    type HdfsServerHostname =
      zio.aws.datasync.model.primitives.HdfsServerHostname.Type
    object HdfsServerPort extends Subtype[Int]
    type HdfsServerPort = zio.aws.datasync.model.primitives.HdfsServerPort.Type
    object HdfsSubdirectory extends Subtype[String]
    type HdfsSubdirectory =
      zio.aws.datasync.model.primitives.HdfsSubdirectory.Type
    object HdfsUser extends Subtype[String]
    type HdfsUser = zio.aws.datasync.model.primitives.HdfsUser.Type
    object IamRoleArn extends Subtype[String]
    type IamRoleArn = zio.aws.datasync.model.primitives.IamRoleArn.Type
    object KerberosKeytabFile extends Subtype[Chunk[Byte]]
    type KerberosKeytabFile =
      zio.aws.datasync.model.primitives.KerberosKeytabFile.Type
    object KerberosKrb5ConfFile extends Subtype[Chunk[Byte]]
    type KerberosKrb5ConfFile =
      zio.aws.datasync.model.primitives.KerberosKrb5ConfFile.Type
    object KerberosPrincipal extends Subtype[String]
    type KerberosPrincipal =
      zio.aws.datasync.model.primitives.KerberosPrincipal.Type
    object KmsKeyProviderUri extends Subtype[String]
    type KmsKeyProviderUri =
      zio.aws.datasync.model.primitives.KmsKeyProviderUri.Type
    object LocationArn extends Subtype[String]
    type LocationArn = zio.aws.datasync.model.primitives.LocationArn.Type
    object LocationUri extends Subtype[String]
    type LocationUri = zio.aws.datasync.model.primitives.LocationUri.Type
    object LogGroupArn extends Subtype[String]
    type LogGroupArn = zio.aws.datasync.model.primitives.LogGroupArn.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.datasync.model.primitives.MaxResults.Type
    object NetworkInterfaceArn extends Subtype[String]
    type NetworkInterfaceArn =
      zio.aws.datasync.model.primitives.NetworkInterfaceArn.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.datasync.model.primitives.NextToken.Type
    object NfsSubdirectory extends Subtype[String]
    type NfsSubdirectory =
      zio.aws.datasync.model.primitives.NfsSubdirectory.Type
    object ObjectStorageAccessKey extends Subtype[String]
    type ObjectStorageAccessKey =
      zio.aws.datasync.model.primitives.ObjectStorageAccessKey.Type
    object ObjectStorageBucketName extends Subtype[String]
    type ObjectStorageBucketName =
      zio.aws.datasync.model.primitives.ObjectStorageBucketName.Type
    object ObjectStorageCertificate extends Subtype[Chunk[Byte]]
    type ObjectStorageCertificate =
      zio.aws.datasync.model.primitives.ObjectStorageCertificate.Type
    object ObjectStorageSecretKey extends Subtype[String]
    type ObjectStorageSecretKey =
      zio.aws.datasync.model.primitives.ObjectStorageSecretKey.Type
    object ObjectStorageServerPort extends Subtype[Int]
    type ObjectStorageServerPort =
      zio.aws.datasync.model.primitives.ObjectStorageServerPort.Type
    object S3BucketArn extends Subtype[String]
    type S3BucketArn = zio.aws.datasync.model.primitives.S3BucketArn.Type
    object S3Subdirectory extends Subtype[String]
    type S3Subdirectory = zio.aws.datasync.model.primitives.S3Subdirectory.Type
    object ScheduleExpressionCron extends Subtype[String]
    type ScheduleExpressionCron =
      zio.aws.datasync.model.primitives.ScheduleExpressionCron.Type
    object ServerHostname extends Subtype[String]
    type ServerHostname = zio.aws.datasync.model.primitives.ServerHostname.Type
    object SmbDomain extends Subtype[String]
    type SmbDomain = zio.aws.datasync.model.primitives.SmbDomain.Type
    object SmbPassword extends Subtype[String]
    type SmbPassword = zio.aws.datasync.model.primitives.SmbPassword.Type
    object SmbSubdirectory extends Subtype[String]
    type SmbSubdirectory =
      zio.aws.datasync.model.primitives.SmbSubdirectory.Type
    object SmbUser extends Subtype[String]
    type SmbUser = zio.aws.datasync.model.primitives.SmbUser.Type
    object StorageVirtualMachineArn extends Subtype[String]
    type StorageVirtualMachineArn =
      zio.aws.datasync.model.primitives.StorageVirtualMachineArn.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.datasync.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.datasync.model.primitives.TagValue.Type
    object TaggableResourceArn extends Subtype[String]
    type TaggableResourceArn =
      zio.aws.datasync.model.primitives.TaggableResourceArn.Type
    object TaskArn extends Subtype[String]
    type TaskArn = zio.aws.datasync.model.primitives.TaskArn.Type
    object TaskExecutionArn extends Subtype[String]
    type TaskExecutionArn =
      zio.aws.datasync.model.primitives.TaskExecutionArn.Type
    object Time extends Subtype[Instant]
    type Time = zio.aws.datasync.model.primitives.Time.Type
    object VpcEndpointId extends Subtype[String]
    type VpcEndpointId = zio.aws.datasync.model.primitives.VpcEndpointId.Type
  }
  type AgentArnList = List[AgentArn]
  type AgentList = List[zio.aws.datasync.model.AgentListEntry]
  type DestinationNetworkInterfaceArns = List[NetworkInterfaceArn]
  type Ec2SecurityGroupArnList = List[Ec2SecurityGroupArn]
  type FilterList = List[zio.aws.datasync.model.FilterRule]
  type FilterValues = List[FilterAttributeValue]
  type HdfsNameNodeList = List[zio.aws.datasync.model.HdfsNameNode]
  type InputTagList = List[zio.aws.datasync.model.TagListEntry]
  type LocationFilters = List[zio.aws.datasync.model.LocationFilter]
  type LocationList = List[zio.aws.datasync.model.LocationListEntry]
  type OutputTagList = List[zio.aws.datasync.model.TagListEntry]
  type PLSecurityGroupArnList = List[Ec2SecurityGroupArn]
  type PLSubnetArnList = List[Ec2SubnetArn]
  type SourceNetworkInterfaceArns = List[NetworkInterfaceArn]
  type TagKeyList = List[TagKey]
  type TaskExecutionList = List[zio.aws.datasync.model.TaskExecutionListEntry]
  type TaskFilters = List[zio.aws.datasync.model.TaskFilter]
  type TaskList = List[zio.aws.datasync.model.TaskListEntry]
}
