package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.ScheduleExpressionCron
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TaskSchedule(scheduleExpression: ScheduleExpressionCron) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.TaskSchedule = {
    import TaskSchedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.TaskSchedule
      .builder()
      .scheduleExpression(
        ScheduleExpressionCron.unwrap(scheduleExpression): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.TaskSchedule.ReadOnly =
    zio.aws.datasync.model.TaskSchedule.wrap(buildAwsValue())
}
object TaskSchedule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.TaskSchedule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.TaskSchedule =
      zio.aws.datasync.model.TaskSchedule(scheduleExpression)
    def scheduleExpression: ScheduleExpressionCron
    def getScheduleExpression: ZIO[Any, Nothing, ScheduleExpressionCron] =
      ZIO.succeed(scheduleExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.TaskSchedule
  ) extends zio.aws.datasync.model.TaskSchedule.ReadOnly {
    override val scheduleExpression: ScheduleExpressionCron =
      zio.aws.datasync.model.primitives
        .ScheduleExpressionCron(impl.scheduleExpression())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.TaskSchedule
  ): zio.aws.datasync.model.TaskSchedule.ReadOnly = new Wrapper(impl)
}
