package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SmbMountOptions(
    version: Optional[zio.aws.datasync.model.SmbVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.SmbMountOptions = {
    import SmbMountOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.SmbMountOptions
      .builder()
      .optionallyWith(version.map(value => value.unwrap))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.SmbMountOptions.ReadOnly =
    zio.aws.datasync.model.SmbMountOptions.wrap(buildAwsValue())
}
object SmbMountOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.SmbMountOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.SmbMountOptions =
      zio.aws.datasync.model.SmbMountOptions(version.map(value => value))
    def version: Optional[zio.aws.datasync.model.SmbVersion]
    def getVersion: ZIO[Any, AwsError, zio.aws.datasync.model.SmbVersion] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.SmbMountOptions
  ) extends zio.aws.datasync.model.SmbMountOptions.ReadOnly {
    override val version: Optional[zio.aws.datasync.model.SmbVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.version())
        .map(value => zio.aws.datasync.model.SmbVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.SmbMountOptions
  ): zio.aws.datasync.model.SmbMountOptions.ReadOnly = new Wrapper(impl)
}
