package zio.aws.datasync.model
import scala.jdk.CollectionConverters.*
sealed trait FilterType {
  def unwrap: software.amazon.awssdk.services.datasync.model.FilterType
}
object FilterType {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.FilterType
  ): zio.aws.datasync.model.FilterType = value match {
    case software.amazon.awssdk.services.datasync.model.FilterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.FilterType.SIMPLE_PATTERN =>
      val r = SIMPLE_PATTERN
      r
  }
  case object unknownToSdkVersion extends zio.aws.datasync.model.FilterType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.FilterType =
      software.amazon.awssdk.services.datasync.model.FilterType.UNKNOWN_TO_SDK_VERSION
  }
  case object SIMPLE_PATTERN extends zio.aws.datasync.model.FilterType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.FilterType =
      software.amazon.awssdk.services.datasync.model.FilterType.SIMPLE_PATTERN
  }
}
