package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  FsxOntapSubdirectory,
  StorageVirtualMachineArn,
  Ec2SecurityGroupArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLocationFsxOntapRequest(
    protocol: zio.aws.datasync.model.FsxProtocol,
    securityGroupArns: Iterable[Ec2SecurityGroupArn],
    storageVirtualMachineArn: StorageVirtualMachineArn,
    subdirectory: Optional[FsxOntapSubdirectory] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.datasync.model.TagListEntry]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapRequest = {
    import CreateLocationFsxOntapRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapRequest
      .builder()
      .protocol(protocol.buildAwsValue())
      .securityGroupArns(securityGroupArns.map { item =>
        Ec2SecurityGroupArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .storageVirtualMachineArn(
        StorageVirtualMachineArn.unwrap(
          storageVirtualMachineArn
        ): java.lang.String
      )
      .optionallyWith(
        subdirectory.map(value =>
          FsxOntapSubdirectory.unwrap(value): java.lang.String
        )
      )(_.subdirectory)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.CreateLocationFsxOntapRequest.ReadOnly =
    zio.aws.datasync.model.CreateLocationFsxOntapRequest.wrap(buildAwsValue())
}
object CreateLocationFsxOntapRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationFsxOntapRequest =
      zio.aws.datasync.model.CreateLocationFsxOntapRequest(
        protocol.asEditable,
        securityGroupArns,
        storageVirtualMachineArn,
        subdirectory.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def protocol: zio.aws.datasync.model.FsxProtocol.ReadOnly
    def securityGroupArns: List[Ec2SecurityGroupArn]
    def storageVirtualMachineArn: StorageVirtualMachineArn
    def subdirectory: Optional[FsxOntapSubdirectory]
    def tags: Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def getProtocol
        : ZIO[Any, Nothing, zio.aws.datasync.model.FsxProtocol.ReadOnly] =
      ZIO.succeed(protocol)
    def getSecurityGroupArns: ZIO[Any, Nothing, List[Ec2SecurityGroupArn]] =
      ZIO.succeed(securityGroupArns)
    def getStorageVirtualMachineArn
        : ZIO[Any, Nothing, StorageVirtualMachineArn] =
      ZIO.succeed(storageVirtualMachineArn)
    def getSubdirectory: ZIO[Any, AwsError, FsxOntapSubdirectory] =
      AwsError.unwrapOptionField("subdirectory", subdirectory)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapRequest
  ) extends zio.aws.datasync.model.CreateLocationFsxOntapRequest.ReadOnly {
    override val protocol: zio.aws.datasync.model.FsxProtocol.ReadOnly =
      zio.aws.datasync.model.FsxProtocol.wrap(impl.protocol())
    override val securityGroupArns: List[Ec2SecurityGroupArn] = impl
      .securityGroupArns()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.Ec2SecurityGroupArn(item)
      }
      .toList
    override val storageVirtualMachineArn: StorageVirtualMachineArn =
      zio.aws.datasync.model.primitives
        .StorageVirtualMachineArn(impl.storageVirtualMachineArn())
    override val subdirectory: Optional[FsxOntapSubdirectory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subdirectory())
        .map(value =>
          zio.aws.datasync.model.primitives.FsxOntapSubdirectory(value)
        )
    override val tags
        : Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TagListEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapRequest
  ): zio.aws.datasync.model.CreateLocationFsxOntapRequest.ReadOnly =
    new Wrapper(impl)
}
