package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  Ec2SecurityGroupArn,
  Ec2SubnetArn,
  Endpoint,
  VpcEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PrivateLinkConfig(
    vpcEndpointId: Optional[VpcEndpointId] = Optional.Absent,
    privateLinkEndpoint: Optional[Endpoint] = Optional.Absent,
    subnetArns: Optional[Iterable[Ec2SubnetArn]] = Optional.Absent,
    securityGroupArns: Optional[Iterable[Ec2SecurityGroupArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.PrivateLinkConfig = {
    import PrivateLinkConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.PrivateLinkConfig
      .builder()
      .optionallyWith(
        vpcEndpointId.map(value =>
          VpcEndpointId.unwrap(value): java.lang.String
        )
      )(_.vpcEndpointId)
      .optionallyWith(
        privateLinkEndpoint.map(value =>
          Endpoint.unwrap(value): java.lang.String
        )
      )(_.privateLinkEndpoint)
      .optionallyWith(
        subnetArns.map(value =>
          value.map { item =>
            Ec2SubnetArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetArns)
      .optionallyWith(
        securityGroupArns.map(value =>
          value.map { item =>
            Ec2SecurityGroupArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupArns)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.PrivateLinkConfig.ReadOnly =
    zio.aws.datasync.model.PrivateLinkConfig.wrap(buildAwsValue())
}
object PrivateLinkConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.PrivateLinkConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.PrivateLinkConfig =
      zio.aws.datasync.model.PrivateLinkConfig(
        vpcEndpointId.map(value => value),
        privateLinkEndpoint.map(value => value),
        subnetArns.map(value => value),
        securityGroupArns.map(value => value)
      )
    def vpcEndpointId: Optional[VpcEndpointId]
    def privateLinkEndpoint: Optional[Endpoint]
    def subnetArns: Optional[List[Ec2SubnetArn]]
    def securityGroupArns: Optional[List[Ec2SecurityGroupArn]]
    def getVpcEndpointId: ZIO[Any, AwsError, VpcEndpointId] =
      AwsError.unwrapOptionField("vpcEndpointId", vpcEndpointId)
    def getPrivateLinkEndpoint: ZIO[Any, AwsError, Endpoint] =
      AwsError.unwrapOptionField("privateLinkEndpoint", privateLinkEndpoint)
    def getSubnetArns: ZIO[Any, AwsError, List[Ec2SubnetArn]] =
      AwsError.unwrapOptionField("subnetArns", subnetArns)
    def getSecurityGroupArns: ZIO[Any, AwsError, List[Ec2SecurityGroupArn]] =
      AwsError.unwrapOptionField("securityGroupArns", securityGroupArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.PrivateLinkConfig
  ) extends zio.aws.datasync.model.PrivateLinkConfig.ReadOnly {
    override val vpcEndpointId: Optional[VpcEndpointId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcEndpointId())
      .map(value => zio.aws.datasync.model.primitives.VpcEndpointId(value))
    override val privateLinkEndpoint: Optional[Endpoint] = zio.aws.core.internal
      .optionalFromNullable(impl.privateLinkEndpoint())
      .map(value => zio.aws.datasync.model.primitives.Endpoint(value))
    override val subnetArns: Optional[List[Ec2SubnetArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.primitives.Ec2SubnetArn(item)
          }.toList
        )
    override val securityGroupArns: Optional[List[Ec2SecurityGroupArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.primitives.Ec2SecurityGroupArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.PrivateLinkConfig
  ): zio.aws.datasync.model.PrivateLinkConfig.ReadOnly = new Wrapper(impl)
}
